/* AMXMOD X script. 
*
*  Warcraft 3: Frozen Throne
*  by Pimp Daddy (OoTOAoO)
*  http://www.war3ft.com
*  http://www.4hm.net (check forums)
*
*  Credits to:
*  Spacedude (for War3 g_MOD)
*  Ludwig Van (for flamethrower)
*  OLO (for spectating rank info)
*  JGHG for the mole code
*  [AOL]Demandred, [AOL]LuckyJ for help coding it for steam
*  [AOL]Demandred for freezetime exploit fix
*  Everyone at amxmod.net for help
*  joecool12321 for various health related fixes
*  Tri Moon for various improvements (No Race, war3menu, etc...)
*  xeroblood for spotting some bugs for me :)
*  bad-at-this for contributing the status bar code used for godmode (big bad voodoo)
*  kamikaze for...
 		help w/testing version before release
		always helping people out on the forums
		contributing code for the anti-skywalking
*  lui for the delayed ultimate code
*  ryannotfound (war3x.net) for some of the naming conventions used (function names, constants, etc...) and functions
*/

#include <amxmodx>
#include <amxmisc>
#include <dbi>
#include <fun>
#include <engine>

//VERSION NAME AUTHOR
new WC3NAME[] =		"Warcraft 3 Frozen Throne"
new WC3AUTHOR[] =	"Pimp Daddy (OoTOAoO)"
new WC3VERSION[] =	"2.0.5"
//

// THESE ARE THE ONLY OPTIONS THAT NEED TO BE CHANGED DURING COMPILE TIME
#define MOD 1							// 0 = cstrike or czero, 1 = dod
#define ADMIN_LEVEL_WC3 ADMIN_LEVEL_A	// set the admin level required for giving xp and accessing the admin menu (see amxconst.inc)
#define DEBUG 0							// Only use this when coding.. you normally don't want it
#define ADVANCED_DEBUG 0				// Prints debug information to a log file when every function is called, VERY LAGGY
#define ADVANCED_DEBUG_BOTS 0			// Print info for bots too?
#define PRECACHE_WAR3FTSOUNDS 1

#if MOD == 0
	#include <cstrike>
#endif
#if MOD == 1
	#include <dodfun>
	#include <dodx>
#endif

#include "war3ft/constants.inl"
#include "war3ft/effects.inl"
#include "war3ft/XP.inl"
#include "war3ft/events.inl"
#include "war3ft/clientCommands.inl"
#include "war3ft/items.inl"
#include "war3ft/stocks.inl"
#include "war3ft/war3ft.inl"
#include "war3ft/ultimates.inl"

#if MOD == 1
	#include "war3ft/dod.inl"
#endif

#if ADVANCED_DEBUG == 1
	public writeDebugInfo(info[], id){
		#if ADVANCED_DEBUG_BOTS == 0
			if(is_user_bot(id))
				return PLUGIN_CONTINUE
		#endif
		if (g_configFound == 0){
			get_configsdir(g_configsDir, 63)
			g_configFound = 1
		}
		new fileInfo[64], string[128]
		format(fileInfo,63,"%s/war3ft.log", g_configsDir)

		new name[32] = ""
		if(is_user_connected(id))
			get_user_name(id,name,31)
		format(string,127,"[%-24s] [%-2d] [%-32s]",info, id, name)

		if (keepTrack == 0){
			keepTrack = 1
			write_file(fileInfo, "******** A new map has loaded", -1)
		}
		write_file(fileInfo, string, -1)
		
		return PLUGIN_CONTINUE
	}
#endif

public getuserinput(parm[1]){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("getuserinput",parm[0])
	#endif

	new id = parm[0]

	if(!is_user_connected(id))
		return PLUGIN_CONTINUE

	new skillsused = p_data[id][P_SKILL1]+p_data[id][P_SKILL2]+p_data[id][P_SKILL3]+p_data[id][P_ULTIMATE]
	if (p_data[id][P_RACE] == 0){
		WAR3_chooserace(id)
	}
	else if (skillsused < p_data[id][P_LEVEL])
		select_skill(id,0)
	else
		WAR3_Display_Level(id, DISPLAYLEVEL_NONE)

	return PLUGIN_HANDLED
}


public restart_round(){						// Called when the round restarts (and game commencing message)
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("restart_round",0)
	#endif

	if (warcraft3==false)
		return PLUGIN_CONTINUE

	
	new players[32]
	new numplayers
	new id
	get_players(players, numplayers)
	write_all()
	for (new i=0; i<numplayers; i++){
		id = players[i]
		p_data[id][P_ITEM] = 0
		p_data[id][P_ITEM2] = 0
		p_data_b[id][PB_DIEDLASTROUND] = false
		if(iCvar[MP_SAVEXP]==0){
			p_data[id][P_LEVEL]=0
			p_data[id][P_RACE]=0
			p_data[id][P_SKILL1]=0
			p_data[id][P_SKILL2]=0
			p_data[id][P_SKILL3]=0
			p_data[id][P_ULTIMATE]=0
			p_data[id][P_XP]=0
		}
		#if MOD == 0
			p_data[id][P_HECOUNT]=0
			p_data[id][P_FLASHCOUNT]=0
		#endif
	}
	
	return PLUGIN_CONTINUE
}

public transport(parm[6]){ // Teleports the ITEM_MOLE to the opposing team's base 
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("transport",parm[5])
	#endif

	new Float:spawnAngle[3] 
	new id = parm[5] 

	if(!is_user_connected(id))
		return PLUGIN_CONTINUE

	p_data_b[id][PB_MOLE] = true
	changeskin(id,SKIN_SWITCH)

	entity_get_vector(parm[3],EV_VEC_angles,spawnAngle) 
	entity_set_vector(id,EV_VEC_angles,spawnAngle)

	new origin[3] 
	origin[0] = parm[0] 
	origin[1] = parm[1] 
	origin[2] = parm[2] 
	set_user_origin(id,origin) 

	Create_ScreenShake(id, (255<< 14), (10 << 14), (255<< 14))

	return PLUGIN_CONTINUE
}

public reset_godmode(parm[]){							// Resets God mode
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("reset_godmode",parm[0])
	#endif

	new id = parm[0]

	if(!is_user_connected(id))
		return PLUGIN_CONTINUE

	new const MAXPLAYERS = get_global_int(GL_maxClients)
	new zone = 255

	if(p_data[P_ITEM2][id]==ITEM_HELM)
		zone = 253

	for (new j = 1; j <= MAXPLAYERS; j++){
		set_user_hitzones(j, id, zone)
	}

	entity_set_int(id,EV_INT_effects,0)

	icon_controller(id,ICON_HIDE)

	p_data[id][P_ULTIMATEDELAY] = iCvar[FT_ULTIMATE_COOLDOWN]
	_WAR3_Ultimate_Delay(parm)

	return PLUGIN_CONTINUE
}

public check_spot(parm[]){ // For ITEM_MOLE, checks to see if there is an open spot on the other team's spawn 
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("check_spot",parm[0])
	#endif

	new id = parm[0]

	if(!is_user_connected(id))
		return PLUGIN_CONTINUE

	new teamnumber=get_user_team(id)
	const maxSpawns = 128
	new spawnPoints[maxSpawns]
	new ent = 0, spawnsFound = 0
	do {
		ent = find_ent_by_class(ent,spawnEntString[teamnumber - 1])
		if (ent != 0) {
			spawnPoints[spawnsFound] = ent
			spawnsFound++
		}
	}
	while (ent && spawnsFound < maxSpawns)

	new bool:foundFreeSpawn
	new Float:spawnOrigin[3]
	new Float:vicinity = 96.0		//(32x32x96)
	new ii
	new playersInVicinity
	new entList[1]
	for (ii = 0;ii < spawnsFound && !foundFreeSpawn;ii++) {
		entity_get_vector(spawnPoints[ii],EV_VEC_origin,spawnOrigin)
		playersInVicinity = find_sphere_class(0, "player", vicinity, entList, 1, spawnOrigin)
		if (playersInVicinity == 0){
			if (!g_spawnPointsUsed[ii]){
				foundFreeSpawn = true
				g_spawnPointsUsed[ii]=true
			}
		}
		else {
			foundFreeSpawn = false
		}
	}

	if (!foundFreeSpawn) { 
		// Didn't find a free spawn spot. Quit... 
		if(parm[1]!=7){
			set_user_money(id,get_user_money(id)+itemcost2[8],1)
			client_print(id,print_chat,"%L",id,"NO_SPOT_MOLE_MONEY",g_MOD)
		}
		else{
			client_print(id,print_chat,"%L",id,"NO_SPOT_TO_MOLE")
		}
		return PLUGIN_CONTINUE 
	}

	if(p_data[id][P_ITEM2] == ITEM_MOLE)
		p_data[id][P_ITEM2] = 0

	new parm2[6], i=0
	for(i = 0; i < 3; i++)
		parm2[i] = floatround(spawnOrigin[i]) 
	parm2[3] = spawnPoints[ii] 
	parm2[4] = teamnumber 
	parm2[5] = id 
	set_task(0.1,"transport",TASK_TRANSPORT+id,parm2,6) 

	return PLUGIN_HANDLED 
} 

public check_blink(id){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("check_blink",id)
	#endif

	if (((p_data[id][P_RACE] == 9 && race9Options[2] == 7) || p_data[id][P_RACE] == 7) && p_data[id][P_SKILL2]){			// Blink
		new Float:randomnumber = random_float(0.0,1.0)
		if (randomnumber <= p_blink[p_data[id][P_SKILL2]-1])
			p_data_b[id][PB_WARDENBLINK]=true	
		else
			p_data_b[id][PB_WARDENBLINK]=false
	}
	else
		p_data_b[id][PB_WARDENBLINK]=false
}

public check_fan(id){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("check_fan",id)
	#endif

	if (((p_data[id][P_RACE] == 9 && race9Options[1] == 7) || p_data[id][P_RACE] == 7) && p_data[id][P_SKILL1] && is_user_alive(id)){			//Fan of Knives
		new Float:randomnumber = random_float(0.0,1.0)
		if (randomnumber <= p_fan[p_data[id][P_SKILL1]-1]){
			new parm[2]
			parm[0]=id
			parm[1]=7
			set_task(0.1,"check_spot",TASK_FAN+id,parm,2)
		}
	}
}

public check_skills(id){							// Gives skill abilities at beginning of round and when skills are selected
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("check_skills",id)
	#endif

	new parm[2]
	parm[0]=id

	if (((p_data[id][P_RACE] == 9 && race9Options[1] == 4) || p_data[id][P_RACE] == 4) && p_data[id][P_SKILL1] && p_data_b[id][PB_EVADENEXTSHOT]){		// Evasion
		set_user_health(id,1124)
	}
	else if (((p_data[id][P_RACE] == 9 && race9Options[2] == 2) || p_data[id][P_RACE] == 2) && p_data[id][P_SKILL2]){		// Devotion Aura
		set_user_health(id,p_devotion[p_data[id][P_SKILL2]-1])
	}


	if (((p_data[id][P_RACE] == 9 && race9Options[1] == 6) || p_data[id][P_RACE] == 6) && p_data[id][P_SKILL1]){			// Healing Wave
		if (task_exists(id+TASK_WAVE))
			remove_task(id+TASK_WAVE)
		set_task(1.0,"healitnow",TASK_WAVE+id,parm,2)
	}
	else{
		if (task_exists(id+TASK_WAVE))
			remove_task(id+TASK_WAVE)
	}

	if (((p_data[id][P_RACE] == 9 && race9Options[3] == 6) || p_data[id][P_RACE] == 6) && p_data[id][P_SKILL3])			// Serpent Ward
		p_data[id][P_SERPENTCOUNT]=p_serpent[p_data[id][P_SKILL3]-1]
	else
		p_data[id][P_SERPENTCOUNT]=0

	check_blink(id)
		
	if (((p_data[id][P_RACE] == 9 && race9Options[1] == 5) || p_data[id][P_RACE] == 5) && p_data[id][P_SKILL1] && is_user_alive(id)){			// Pheonix
		new Float:randomnumber = random_float(0.0,1.0)
		new teamnumber = get_user_team(id)
		if (randomnumber <= p_pheonix[p_data[id][P_SKILL1]-1]){
			p_data_b[id][PB_PHEONIXCASTER] = true
			if (teamnumber==1)
				g_pheonixExistsT++
			else
				g_pheonixExistsCT++
		}
	}
	icon_controller(id,ICON_SHOW)

	return PLUGIN_CONTINUE
}

public item_functions(parm[]){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("item_functions",parm[0])
	#endif

	new id = parm[0]
	
	if(!is_user_connected(id))
		return PLUGIN_CONTINUE

	if(p_data[id][P_ITEM2]==ITEM_MOLE)
		set_task(0.1,"check_spot",TASK_FAN+12,parm,2)
		
	if(p_data_b[id][PB_DIEDLASTROUND]){
		p_data[id][P_ITEM]=0
		p_data[id][P_ITEM2]=0
		WAR3_Display_Level(id,DISPLAYLEVEL_NONE)
	}

	p_data_b[id][PB_DIEDLASTROUND]=false
	
	if(get_cvar_num("sv_gravity")>650){
		if (((p_data[id][P_RACE] == 9 && race9Options[3] == 1) || p_data[id][P_RACE] == 1) && p_data[id][P_SKILL3]){		// Levitation
			if (get_user_gravity(id)!=p_levitation[p_data[id][P_SKILL3]-1])
				set_user_gravity(id,p_levitation[p_data[id][P_SKILL3]-1])
		}
		else
			set_user_gravity(id,1.0)
	}
	else
		set_user_gravity(id,1.0)

	if(p_data[id][P_ITEM2]!=ITEM_CHAMELEON && (p_data[id][P_SKINCHANGED] == SKIN_HEX || p_data[id][P_SKINCHANGED]==SKIN_SWITCH))
		changeskin(id,SKIN_RESET)

	if (task_exists(TASK_ITEM_RINGERATE+id) && p_data[id][P_ITEM2]!=ITEM_RING)
		remove_task(TASK_ITEM_RINGERATE+id)

	if (p_data[id][P_ITEM]==ITEM_HEALTH)
		set_user_health(id,get_user_health(id)+iCvar[FT_HEALTH_BONUS])
	
	if(p_data[id][P_ITEM2]==ITEM_RING && !task_exists(TASK_ITEM_RINGERATE+id))
		regenerate(parm)

	if (p_data[id][P_ITEM2]==ITEM_CHAMELEON && is_user_alive(id))
		changeskin(id,SKIN_SWITCH)

	return PLUGIN_CONTINUE
}


public resetSkills(id,saychat){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("resetSkills",id)
	#endif

	if (warcraft3==false)
		return PLUGIN_CONTINUE
	if(g_mapDisabled)
		return PLUGIN_CONTINUE

	if (iCvar[FT_CD]) {
		if (!WAR3_CD_installed(id)){
			client_print(id,print_chat,"%L",id,"CHEATING_DEATH_NOT_INSTALLED",g_MOD)
			return PLUGIN_CONTINUE
		}
	}

	if(saychat==1){
		client_print(id,print_center,"%L",id,"SKILLS_RESET_NEXT_ROUND")
	}
	else{
		console_print(id,"%L",id,"SKILLS_RESET_NEXT_ROUND")
	}
	p_data_b[id][PB_RESETSKILLS]=true


	return PLUGIN_HANDLED
}

public reset_position(parm[4]){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("reset_position",parm[0])
	#endif

	new id = parm[0]

	if(!is_user_connected(id))
		return PLUGIN_CONTINUE

	new origin[3]
	origin[0]=parm[1]
	origin[1]=parm[2]
	origin[2]=parm[3]
	set_user_origin(id,origin)

	return PLUGIN_CONTINUE
}

public weapon_controller( parm[2]  ){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("weapon_controller",parm[0])
	#endif

	if (warcraft3==false)
		return PLUGIN_CONTINUE

	if(g_mapDisabled)
		return PLUGIN_CONTINUE

	#if MOD == 0
		new id = parm[0]
		
		if(!is_user_connected(id))
			return PLUGIN_CONTINUE

		new bool:reincarnate = false
		
		// Give items because of respawning...
		if(p_data_b[id][PB_GIVEITEMS]){
			reincarnate = true
			p_data_b[id][PB_GIVEITEMS]=false
		}
									
		// Equipement & Eligibility Check for Re-Incarnation
		if (p_data_b[id][PB_DIEDLASTROUND]){	// DIED LAST ROUND		
			new Float:randomnumber = random_float(0.0,1.0)   
			if (((p_data[id][P_RACE] == 9 && race9Options[3] == 3) || p_data[id][P_RACE] == 3) && p_data[id][P_SKILL3] && randomnumber <= p_ankh[p_data[id][P_SKILL3]-1]){
				reincarnate = true				
			}
			else if (p_data[id][P_ITEM]==ITEM_ANKH)
				reincarnate=true
		}

		if (reincarnate){
				client_cmd(id, "speak warcraft3/soundpack/reincarnation.wav")

				if (iglow[id][1] < 1){
					parm[0] = id
					set_task(0.1,"glow_change",TASK_GLOW+id,parm,2)
				} 
				iglow[id][1] += 100
				iglow[id][0] = 0
				iglow[id][2] = 0
				iglow[id][3] = 0
				if (iglow[id][1]>MAXGLOW)
					iglow[id][1]=MAXGLOW

				// Screen fade green
				Create_ScreenFade(id, (1<<10), (1<<10), (1<<12), 0, 255, 0, iglow[id][1])

				_WAR3_Drop_Items(id)
				_WAR3_Give_Items(id)
		}else{
			if(!cs_get_user_nvg(id))
				p_data_b[id][PB_NIGHTVISION]=false
			if(!cs_get_user_defuse(id))
				p_data_b[id][PB_DEFUSE]=false
		}
	#endif

	item_functions(parm)

	return PLUGIN_HANDLED	
}	

public saveweapons(id){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("saveweapons",id)
	#endif

	#if MOD == 0
		p_data[id][P_ARMORONDEATH]=get_user_armor(id)
	#endif
	for (new i=0; i<32; ++i){		// Equipment Reincarnation
		savedweapons[id][i]=0
	}
	p_data[id][P_SAVEDNUMBER]=0
	get_user_weapons(id,savedweapons[id],p_data[id][P_SAVEDNUMBER])
	return PLUGIN_CONTINUE
}


public select_skill(id,saychat){
	 #if ADVANCED_DEBUG == 1
		writeDebugInfo("select_skill",id)
	#endif

	if (warcraft3==false)
		return PLUGIN_CONTINUE

	if (iCvar[FT_CD]) {
		if (!WAR3_CD_installed(id)){
			client_print(id,print_chat,"%L",id,"CHEATING_DEATH_NOT_INSTALLED",g_MOD)
			return PLUGIN_CONTINUE
		}
	}

	if (p_data[id][P_RACE] == 0){
		if (saychat==1){
			set_hudmessage(200, 100, 0, -1.0, 0.3, 0, 1.0, 5.0, 0.1, 0.2, 2)
			show_hudmessage(id,"%L",id,"SELECT_RACE_BEFORE_SKILLS")
		}
		else{
			console_print(id,"%L",id,"SELECT_RACE_BEFORE_SKILLS")
		}
		return PLUGIN_HANDLED
	}

	new message[256]
	new temp[128]

	new skillsused = p_data[id][P_SKILL1]+p_data[id][P_SKILL2]+p_data[id][P_SKILL3]+p_data[id][P_ULTIMATE]

	if (skillsused>=p_data[id][P_LEVEL]){
		if (saychat==1){
			set_hudmessage(200, 100, 0, -1.0, 0.3, 0, 1.0, 5.0, 0.1, 0.2, 2)
			show_hudmessage(id,"%L",id,"ALREADY_SELECTED_SKILL_POINTS")
		}
		else{
			console_print(id,"%L",id,"ALREADY_SELECTED_SKILL_POINTS")
		}
		return PLUGIN_HANDLED
	}

	if (is_user_bot(id)){
		new randomskill
		while (skillsused < p_data[id][P_LEVEL]){
			randomskill = random_num(1,3)
			if (p_data[id][P_ULTIMATE]==0 && p_data[id][P_LEVEL]>=6)
				p_data[id][P_ULTIMATE]=1
			else if (p_data[id][randomskill]!=3 && p_data[id][P_LEVEL]>2*p_data[id][randomskill]){
				++p_data[id][randomskill]
			}
			skillsused = p_data[id][P_SKILL1]+p_data[id][P_SKILL2]+p_data[id][P_SKILL3]+p_data[id][P_ULTIMATE]
		}
		return PLUGIN_HANDLED
	}

	format(message,255,"%L",id,"MENU_SELECT_SKILL")


	new skillcounter = 0
	new skillcurrentrace[4][64]

	while (skillcounter < 4){
		new race_skill[RACE_SKILL_LENGTH]
		raceskill(p_data[id][P_RACE],skillcounter,id,race_skill,RACE_SKILL_LENGTH_F)
		copy(skillcurrentrace[skillcounter],63,race_skill)

		++skillcounter
	}

	skillcounter = 1
	while (skillcounter< 4){
		if (p_data[id][skillcounter]!=3){
			if (p_data[id][P_LEVEL]<=2*p_data[id][skillcounter]){
				format(temp,127,"\d")
				add(message,255,temp)
			}
			new race_skill[RACE_SKILL_LENGTH]
			raceskill(p_data[id][P_RACE],skillcounter,id,race_skill,RACE_SKILL_LENGTH_F)

			format(temp,127,"%L",id,"LEVEL_SELECT_SKILL_FUNC",skillcounter,race_skill,p_data[id][skillcounter]+1)
			add(message,255,temp)
		}
		++skillcounter
	}
	if (p_data[id][P_ULTIMATE]==0){
		if (p_data[id][P_LEVEL]<=5){
			format(temp,127,"\d")
			add(message,255,temp)
		}
		new race_skill[RACE_SKILL_LENGTH]
		raceskill(p_data[id][P_RACE],4,id,race_skill,RACE_SKILL_LENGTH_F)

		format(temp,127,"%L",id,"ULTIMATE_SELECT_SKILL_FUNC",race_skill)
		add(message,255,temp)
	}

	new keys = (1<<9)

	if (p_data[id][P_SKILL1]!=3 && p_data[id][P_LEVEL]>2*p_data[id][P_SKILL1] && skillsused<p_data[id][P_LEVEL])
		keys |= (1<<0)
	if (p_data[id][P_SKILL2]!=3 && p_data[id][P_LEVEL]>2*p_data[id][P_SKILL2] && skillsused<p_data[id][P_LEVEL])
		keys |= (1<<1)
	if (p_data[id][P_SKILL3]!=3 && p_data[id][P_LEVEL]>2*p_data[id][P_SKILL3] && skillsused<p_data[id][P_LEVEL])
		keys |= (1<<2)
	if (p_data[id][P_ULTIMATE]==0 && p_data[id][P_LEVEL]>=6 && skillsused<p_data[id][P_LEVEL])
		keys |= (1<<3)

	format(temp,127,"%L",id,"CANCEL_SELECT_SKILL_FUNC")
	add(message,255,temp)
	show_menu(id,keys,message,-1)
	if (saychat==1)
		return PLUGIN_CONTINUE
	return PLUGIN_HANDLED
}

public set_skill(id,key){
	 #if ADVANCED_DEBUG == 1
		writeDebugInfo("set_skill",id)
	#endif

	new skillsused = p_data[id][P_SKILL1]+p_data[id][P_SKILL2]+p_data[id][P_SKILL3]+p_data[id][P_ULTIMATE]

	if (key == 0 && p_data[id][P_SKILL1]!=3 && p_data[id][P_LEVEL]>2*p_data[id][P_SKILL1] && skillsused<p_data[id][P_LEVEL])
		++p_data[id][P_SKILL1]
	else if (key == 1 && p_data[id][P_SKILL2]!=3 && p_data[id][P_LEVEL]>2*p_data[id][P_SKILL2] && skillsused<p_data[id][P_LEVEL])
		++p_data[id][P_SKILL2]
	else if (key == 2 && p_data[id][P_SKILL3]!=3 && p_data[id][P_LEVEL]>2*p_data[id][P_SKILL3] && skillsused<p_data[id][P_LEVEL])
		++p_data[id][P_SKILL3]
	else if (key == 3 && p_data[id][P_ULTIMATE]==0 && p_data[id][P_LEVEL]>=6 && skillsused<p_data[id][P_LEVEL]){
		p_data[id][P_ULTIMATE]=1
		p_data_b[id][PB_ULTIMATEUSED]=false
	}
	else if (key == 9)
		return PLUGIN_HANDLED

	skillsused = p_data[id][P_SKILL1]+p_data[id][P_SKILL2]+p_data[id][P_SKILL3]+p_data[id][P_ULTIMATE]
	if (skillsused < p_data[id][P_LEVEL])
		select_skill(id,0)
	else
		WAR3_Display_Level(id, DISPLAYLEVEL_NONE)
	#if MOD == 0
		if(!p_data_b[id][PB_ULTIMATEUSED])
	#else
		if(!p_data_b[id][PB_ULTIMATEUSED])
	#endif
		icon_controller(id,ICON_SHOW)


	// Serpent Ward Chosen
	if (((p_data[id][P_RACE] == 9 && race9Options[3] == 6) || p_data[id][P_RACE] == 6) && key == 2){
		p_data[id][P_SERPENTCOUNT]++
	}
	// Carrion Beetle Chosen
	if (((p_data[id][P_RACE] == 9 && race9Options[3] == 8) || p_data[id][P_RACE] == 8) && key == 2 && p_data[id][P_SKILL3] == 1){
		p_data[id][P_CARRIONCOUNT] = 2
	}
	// Shadow Strike Chosen
	if (((p_data[id][P_RACE] == 9 && race9Options[3] == 7) || p_data[id][P_RACE] == 7) && key == 2 && p_data[id][P_SKILL3] == 1){
		p_data[id][P_SHADOWCOUNT] = 2
	}
	// Devotion Aura Chosen
	if (((p_data[id][P_RACE] == 9 && race9Options[2] == 2) || p_data[id][P_RACE] == 2) && key == 1 && is_user_alive(id)){
		if(p_data[id][P_SKILL2]==1)
			set_user_health(id,get_user_health(id) + (p_devotion[0] - 100))
		else if(p_data[id][P_SKILL2]==2)
			set_user_health(id,get_user_health(id) + (p_devotion[1] - p_devotion[0]))
		else if(p_data[id][P_SKILL2]==3)
			set_user_health(id,get_user_health(id) + (p_devotion[2] - p_devotion[1]))
	}

	return PLUGIN_HANDLED
}

public set_race(id,key){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("set_race",id)
	#endif

	new race, autoselectkey

	if(iCvar[FT_RACES] == 9)
		autoselectkey = KEY_0
	else
		autoselectkey = iCvar[FT_RACES]

	if (key == autoselectkey)
		race = random_num(1,iCvar[FT_RACES])
	else
		race = (key+1)

	if(p_data[id][P_RACE]!=0){
		if(race != p_data[id][P_RACE])
			p_data[id][P_CHANGERACE] = race
	}
	else
		WAR3_set_race(id, race)

	return PLUGIN_HANDLED
}

public jumper(parm[2]){
	new id = parm[0]

	if(!is_user_connected(id))
		return PLUGIN_CONTINUE

	client_cmd(id,"+jump;wait;-jump")
	parm[1]++
	if(!endround && is_user_alive(id))
		set_task(4.0,"jumper",TASK_JUMPER+id,parm,1)
	
	return PLUGIN_CONTINUE
}

public apacheexplode(parm[5]){		// Suicide Bomber
	new id = parm[0]
	// random explosions

	new origin[3], origin2[3]
	origin[0] = parm[2]
	origin[1] = parm[3]
	origin[2] = parm[4]

	origin2[0] = origin[0] + random_num( -100, 100 )
	origin2[1] = origin[1] + random_num( -100, 100 )
	origin2[2] = origin[2] + random_num( -50, 50 )
	
	Create_TE_EXPLOSION(origin, origin2, g_sFireball, (random_num(0,20) + 20), 12, TE_EXPLFLAG_NONE)

#if MOD == 0
	Create_TE_Smoke(origin, origin2, g_sSmoke, 60, 10)
#endif

	new players[32]
	new numberofplayers
	get_players(players, numberofplayers)
	new i
	new targetid
	new distancebetween
	new targetorigin[3]
	new damage
	new multiplier

	for (i = 0; i < numberofplayers; ++i){
		targetid=players[i]
		get_user_origin(targetid,targetorigin)
		distancebetween=get_distance(origin,targetorigin)
		if (distancebetween < EXPLOSION_RANGE && get_user_team(id)!=get_user_team(targetid) && p_data[targetid][P_ITEM]!=ITEM_NECKLACE && !p_data_b[targetid][PB_WARDENBLINK]){
			multiplier=(EXPLOSION_MAX_DAMAGE*EXPLOSION_MAX_DAMAGE)/EXPLOSION_RANGE
			damage=(EXPLOSION_RANGE-distancebetween)*multiplier
			damage=sqrt(damage)
			if(is_user_alive(targetid))
				WAR3_damage(targetid, id, damage, CSW_SUICIDE, 0)

		}
		if (distancebetween < EXPLOSION_RANGE){
			Create_ScreenShake(targetid, (1<<14), (1<<13), (1<<14))
		}
	}

	--parm[1]
	if (parm[1]>0)
		set_task(0.1,"apacheexplode",TASK_EXPLOSION+id,parm,5)
	return PLUGIN_CONTINUE
}

public blastcircles(parm[5]){
	// Create Blast Circles
	new origin[3], origin2[3]

	origin[0] = parm[2]
	origin[1] = parm[3]
	origin[2] = parm[4] - 16

	origin2[0] = origin[0]
	origin2[1] = origin[1]
	origin2[2] = origin[2] + EXPLOSION_BLAST_RADIUS

	Create_TE_BEAMCYLINDER(origin, origin, origin2, g_sSpriteTexture, 0, 0, 6, 16, 0, 188, 220, 255, 255, 0)

	origin2[2] = (origin[2] - EXPLOSION_BLAST_RADIUS) + (EXPLOSION_BLAST_RADIUS / 2 )

	Create_TE_BEAMCYLINDER(origin, origin, origin2, g_sSpriteTexture, 0, 0, 6, 16, 0, 188, 220, 255, 255, 0)

	return PLUGIN_CONTINUE
}


public glow_change(parm[]){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("glow_change",parm[0])
	#endif

	new id = parm[0]

	if(!is_user_connected(id))
		return PLUGIN_CONTINUE

	if (((p_data[id][P_RACE] == 9 && race9Options[1] == 2) || p_data[id][P_RACE] == 2) && p_data[id][P_SKILL1]){	// Don't glow if player is invisible
		iglow[id][0] = 0
		iglow[id][1] = 0
		iglow[id][2] = 0
		iglow[id][3] = 0
	}
	else if (p_data[id][P_ITEM]==ITEM_CLOAK){		// Don't glow if player is invisible
		iglow[id][0] = 0
		iglow[id][1] = 0
		iglow[id][2] = 0
		iglow[id][3] = 0
	}
	else if (iglow[id][0] > 5){
		set_user_rendering(id,kRenderFxGlowShell,iglow[id][0],0,0, kRenderNormal, 16)
		iglow[id][0] -= 5
		set_task(0.2,"glow_change",TASK_GLOW+id,parm,2)
	}
	else if (iglow[id][1] > 5){
		set_user_rendering(id,kRenderFxGlowShell,0,iglow[id][1],0, kRenderNormal, 16)
		iglow[id][1] -= 5
		set_task(0.2,"glow_change",TASK_GLOW+id,parm,2)
	}
	else if (iglow[id][2] > 5){
		set_user_rendering(id,kRenderFxGlowShell,0,0,iglow[id][2], kRenderNormal, 16)
		iglow[id][2] -= 5
		set_task(0.2,"glow_change",TASK_GLOW+id,parm,2)
	}
	else if (iglow[id][3] > 5){
		set_user_rendering(id,kRenderFxGlowShell,iglow[id][3],iglow[id][3],iglow[id][3], kRenderNormal, 16)
		iglow[id][3] -= 5
		set_task(0.2,"glow_change",TASK_GLOW+id,parm,2)
	}
	else{
		iglow[id][0] = 0
		iglow[id][1] = 0
		iglow[id][2] = 0
		iglow[id][3] = 0
		set_user_rendering(id)
	}
	return PLUGIN_CONTINUE
}

public reset_maxspeed(parm[]){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("reset_maxspeed",parm[0])
	#endif

	new enemy = parm[0]

	if(!is_user_connected(enemy))
		return PLUGIN_CONTINUE

	new normalspeed = parm[1]
	p_data_b[enemy][PB_STUNNED]=false
	p_data_b[enemy][PB_SLOWED]=false
	set_user_maxspeed(enemy, float(normalspeed))
	return PLUGIN_CONTINUE
}

public nadetimer(parm[2]){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("nadetimer",parm[0])
	#endif

	new id = parm[0]

	if(!is_user_connected(id))
		return PLUGIN_CONTINUE

	set_hudmessage(0, 100, 0, 0.05, 0.65, 2, 0.02, 10.0, 0.01, 0.1, 2)	
	if(p_data[id][P_ITEM2]!=ITEM_GLOVES){
		show_hudmessage(id,"")
		return PLUGIN_HANDLED
	}

	if(p_data[id][P_NADETIME]!=0){
		show_hudmessage(id,"%L", id, "UNTIL_YOUR_NEXT_GRENADE", p_data[id][P_NADETIME])
	}
	p_data[id][P_NADETIME] -= 1
	if (!is_user_alive(id)){
		show_hudmessage(id,"%L",id,"DONT_DIE_GOOSE")
	}


	if (p_data[id][P_NADETIME]!=-1&& is_user_alive(parm[0]))
		set_task(1.0,"nadetimer",TASK_ITEM_GLOVES+id,parm,2)
	if (p_data[id][P_NADETIME]==-1){
		giveheifnothas(parm)
		p_data[id][P_NADETIME] = iCvar[FT_GLOVE_TIMER]
		return PLUGIN_HANDLED
	}

	return PLUGIN_CONTINUE
}

public unholyspeed(parm[1]){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("unholyspeed",parm[0])
	#endif

	if (warcraft3==false)
		return PLUGIN_CONTINUE

	new id = parm[0]

	if(!is_user_connected(id))
		return PLUGIN_CONTINUE

	if (p_data_b[id][PB_STUNNED]){
		set_user_maxspeed(id,1.0)
		return PLUGIN_HANDLED
	}
	else if (p_data_b[id][PB_SLOWED]){
		set_user_maxspeed(id,fCvar[FT_FROST_SPEED])
		return PLUGIN_HANDLED
	}
#if MOD == 0
	else if (get_user_maxspeed(id)>5 && ((p_data[id][P_RACE] == 9 && race9Options[2] == 1) || p_data[id][P_RACE] == 1) && p_data[id][P_SKILL2] && !g_freezetime){              // Unholy Aura
		if (get_user_maxspeed(id)>5 && get_user_maxspeed(id)!=p_unholy[p_data[id][P_SKILL2]-1])
			set_user_maxspeed(id,(p_unholy[p_data[id][P_SKILL2]-1]))
	}

	else if (get_user_maxspeed(id)>5 && p_data[id][P_ITEM]==ITEM_BOOTS && !g_freezetime){			// Boots of Speed
		if (get_user_maxspeed(id)!=fCvar[FT_BOOTSPEED])
			set_user_maxspeed(id,fCvar[FT_BOOTSPEED])
	}
#endif
#if MOD == 1
	else if (get_user_maxspeed(id)>5 && p_data[id][P_ITEM]==ITEM_BOOTS){			// Boots of Speed
		if (get_user_maxspeed(id)!=fCvar[DOD_BOOTSPEED])
			set_user_maxspeed(id,fCvar[DOD_BOOTSPEED])
	}
#endif

	return PLUGIN_CONTINUE
}

public items_info(id,saychat){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("items_info",id)
	#endif

	if (warcraft3==false)
		return PLUGIN_CONTINUE

	if (iCvar[FT_CD]) {
		if (!WAR3_CD_installed(id)){
			client_print(id,print_chat,"%L",id,"CHEATING_DEATH_NOT_INSTALLED",g_MOD)
			return PLUGIN_CONTINUE
		}
	}

	new temp[1024], pos = 0
	new theforward[8],backward[8]
	if(iCvar[FT_STEAM]){
		format(theforward,7,"<li>")
		format(backward,7,"</li>")
		pos += format(temp[pos], 1024-pos, "<body bgcolor=#000000><font color=#FFB000>")
	}
	else{
		format(theforward,7,"")
		format(backward,7,"^n")
	}

	new item_name[9][ITEM_NAME_LENGTH]
	for(new i=0;i<9;i++){
		itemname(i+1,id,item_name[i],ITEM_NAME_LENGTH_F)
	}

	if(saychat==1){
		pos += format(temp[pos], 1024-pos, "%s %L %s",theforward,id,"SHOPMENU_1",item_name[0],backward)
		pos += format(temp[pos], 1024-pos, "%s %L %s",theforward,id,"SHOPMENU_2",item_name[1],backward)
		pos += format(temp[pos], 1024-pos, "%s %L %s",theforward,id,"SHOPMENU_3",item_name[2],iCvar[FT_CLAW],iCvar[FT_CLAW],backward)
		pos += format(temp[pos], 1024-pos, "%s %L %s",theforward,id,"SHOPMENU_4",item_name[3],backward)
		pos += format(temp[pos], 1024-pos, "%s %L %s",theforward,id,"SHOPMENU_5",item_name[4],backward)
		pos += format(temp[pos], 1024-pos, "%s %L %s",theforward,id,"SHOPMENU_6",item_name[5],backward)
		pos += format(temp[pos], 1024-pos, "%s %L %s",theforward,id,"SHOPMENU_7",item_name[6],backward)
		pos += format(temp[pos], 1024-pos, "%s %L %s",theforward,id,"SHOPMENU_8",item_name[7],backward)
		pos += format(temp[pos], 1024-pos, "%s %L %s",theforward,id,"SHOPMENU_9",item_name[8],backward)

		new motdmessage[128]
		format(motdmessage, 127, "%L",id,"SHOPMENU_TITLE")
		show_motd(id,temp,motdmessage)

	}
	else{
		console_print(id,"---- %L ----",id,"SHOPMENU_TITLE")
		console_print(id,"%L",id,"SHOPMENU_1",item_name[0])
		console_print(id,"%L",id,"SHOPMENU_2",item_name[1])
		console_print(id,"%L",id,"SHOPMENU_3",item_name[2],iCvar[FT_CLAW],iCvar[FT_CLAW])
		console_print(id,"%L",id,"SHOPMENU_4",item_name[3])
		console_print(id,"%L",id,"SHOPMENU_5",item_name[4])
		console_print(id,"%L",id,"SHOPMENU_6",item_name[5])
		console_print(id,"%L",id,"SHOPMENU_7",item_name[6])
		console_print(id,"%L",id,"SHOPMENU_8",item_name[7])
		console_print(id,"%L",id,"SHOPMENU_9",item_name[8])
		console_print(id,"---- %L ----",id,"SHOPMENU_TITLE")
	}

	return PLUGIN_CONTINUE
}

public items_info2(id,saychat){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("items_info2",id)
	#endif

	if (warcraft3==false)
		return PLUGIN_CONTINUE
	if(iCvar[FT_RACES] < 5)
		return PLUGIN_CONTINUE

	if (iCvar[FT_CD]) {
		if (!WAR3_CD_installed(id)){
			client_print(id,print_chat,"%L",id,"CHEATING_DEATH_NOT_INSTALLED",g_MOD)
			return PLUGIN_CONTINUE
		}
	}

	new temp[1024], pos = 0
	new theforward[8],backward[8]
	if(iCvar[FT_STEAM]){
		format(theforward,7,"<li>")
		format(backward,7,"</li>")
		pos += format(temp[pos], 1024-pos, "<body bgcolor=#000000><font color=#FFB000>")
	}
	else{
		format(theforward,7,"")
		format(backward,7,"^n")
	}

	new item_name2[9][ITEM_NAME_LENGTH_F]
	for(new i=0;i<9;i++){
		itemname2(i+1,id,item_name2[i],ITEM_NAME_LENGTH_F)
	}

	if(saychat==1){
		pos += format(temp[pos], 1024-pos, "%s %L %s",theforward,id,"SHOPMENU2_1",item_name2[0],backward)
		pos += format(temp[pos], 1024-pos, "%s %L %s",theforward,id,"SHOPMENU2_2",item_name2[1],backward)
		pos += format(temp[pos], 1024-pos, "%s %L %s",theforward,id,"SHOPMENU2_3",item_name2[2],backward)
		pos += format(temp[pos], 1024-pos, "%s %L %s",theforward,id,"SHOPMENU2_4",item_name2[3],backward)
		pos += format(temp[pos], 1024-pos, "%s %L %s",theforward,id,"SHOPMENU2_5",item_name2[4],backward)
		pos += format(temp[pos], 1024-pos, "%s %L %s",theforward,id,"SHOPMENU2_6",item_name2[5],iCvar[FT_GLOVE_TIMER],backward)
		pos += format(temp[pos], 1024-pos, "%s %L %s",theforward,id,"SHOPMENU2_7",item_name2[6],backward)
		pos += format(temp[pos], 1024-pos, "%s %L %s",theforward,id,"SHOPMENU2_8",item_name2[7],backward)
		pos += format(temp[pos], 1024-pos, "%s %L %s",theforward,id,"SHOPMENU2_9",item_name2[8],backward)

		new motdmessage[128]
		format(motdmessage, 127, "%L",id,"SHOPMENU2_TITLE")
		show_motd(id,temp,motdmessage)
	}
	else{
		console_print(id,"%L",id,"---- SHOPMENU2_TITLE ----")
		console_print(id,"%L",id,"SHOPMENU2_1",item_name2[0])
		console_print(id,"%L",id,"SHOPMENU2_2",item_name2[1])
		console_print(id,"%L",id,"SHOPMENU2_3",item_name2[2])
		console_print(id,"%L",id,"SHOPMENU2_4",item_name2[3])
		console_print(id,"%L",id,"SHOPMENU2_5",item_name2[4])
		console_print(id,"%L",id,"SHOPMENU2_6",item_name2[5],iCvar[FT_GLOVE_TIMER])
		console_print(id,"%L",id,"SHOPMENU2_7",item_name2[6])
		console_print(id,"%L",id,"SHOPMENU2_8",item_name2[7])
		console_print(id,"%L",id,"SHOPMENU2_9",item_name2[8])
		console_print(id,"%L",id,"---- SHOPMENU2_TITLE ----")
	}

	return PLUGIN_CONTINUE
}

public war3_info(id, saychat){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("war3_info",id)
	#endif

	if (warcraft3==false)
		return PLUGIN_CONTINUE

	if (iCvar[FT_CD]) {
		if (!WAR3_CD_installed(id)){
			client_print(id,print_chat,"%L",id,"CHEATING_DEATH_NOT_INSTALLED",g_MOD)
			return PLUGIN_CONTINUE
		}
	}

	new temp[2048], message[1024], title[128]
	new pos = 0
	new thereturn[8], thep[8]

	if(iCvar[FT_STEAM]){
		format(thereturn,7,"<br>")
		format(thep,7,"<p>")
		pos += format(message[pos], 1024-pos, "<body bgcolor=#000000><font color=#FFB000>")
		pos += format(message[pos], 1024-pos, "%L",id,"THIS_MOD_WAS_DEVELOPED",thereturn)
		pos += format(message[pos], 1024-pos, "%L",id,"CLICK_HERE_FOR_LATEST",thereturn)		
		pos += format(message[pos], 1024-pos, "%L",id,"CLICK_HERE")
	}
	else{
		format(thereturn,7,"^n")
		format(thep,7,"^n^n")
		pos += format(message[pos], 1024-pos, "%L",id,"THIS_g_MOD_WAS_DEVELOPED",thereturn)
	}

	if(saychat==1){
		format(title,127,"%L",id,"WAR3HELP_TITLE")
		format(temp,2047,"%L",id,"WAR3HELP",message,thep,thereturn,thereturn,thereturn,thereturn,thep,thep,thereturn,thereturn,thereturn,thereturn,thereturn,thereturn,thereturn,thereturn,thereturn,thereturn,thereturn,thereturn)
		show_motd(id,temp,title)
	}
	else{		// Currently doesn't work correctly
		thereturn = "^n"
		thep = "^n"
		format(title,127,"---- %L ----^n^n",id,"WAR3HELP_TITLE")
		format(temp,2047,"%L",id,"WAR3HELP",title,thep,thereturn,thereturn,thereturn,thereturn,thep,thep,thereturn,thereturn,thereturn,thereturn,thereturn,thereturn,thereturn,thereturn,thereturn,thereturn,thereturn,thereturn)
		console_print(id,temp)
	}

	return PLUGIN_HANDLED
}

public ultimate(id){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("ultimate",id)
	#endif

	if (warcraft3==false)
		return PLUGIN_CONTINUE

	if (iCvar[FT_CD]) {
		if (!WAR3_CD_installed(id)){
			client_print(id,print_chat,"%L",id,"CHEATING_DEATH_NOT_INSTALLED",g_MOD)
			return PLUGIN_HANDLED
		}
	}

	if (!is_user_alive(id))
		return PLUGIN_HANDLED

	if(!p_data[id][P_ULTIMATE]){
		new message[128]
		format(message, 127, "%L",id,"ULTIMATE_NOT_FOUND")
		WAR3_status_text(id, message, 0.5)
		client_cmd(id, "speak warcraft3/bonus/Error.wav")
		return PLUGIN_HANDLED
	}

	if(p_data_b[id][PB_ULTIMATEUSED]){
		new message[128]
		format(message, 127, "%L",id,"ULTIMATE_NOT_READY",p_data[id][P_ULTIMATEDELAY])
		WAR3_status_text(id, message, 0.5)
		client_cmd(id, "speak warcraft3/bonus/Error.wav")
		return PLUGIN_HANDLED
	}

	if (((p_data[id][P_RACE] == 9 && race9Options[4] == 8) || p_data[id][P_RACE] == 8) && p_data[id][P_ULTIMATE]==1 && !p_data_b[id][PB_ULTIMATEUSED]){	// Locust Swarm
		calllocustfunction(id)
	}
	else if (((p_data[id][P_RACE] == 9 && race9Options[4] == 1) || p_data[id][P_RACE] == 1) && p_data[id][P_ULTIMATE]==1){
		if (iCvar[FT_WARN_SUICIDE]){
			if( p_data_b[id][PB_SUICIDEATTEMPT] ){
				set_msg_block(gmsgDeathMsg,BLOCK_ONCE)
				user_kill(id)
				client_death(0, id, 0, 0, 0)
			}else{
				new parm[1]
				parm[0]=id
				icon_controller(id,ICON_FLASH)
				p_data_b[id][PB_SUICIDEATTEMPT] = true
				set_hudmessage(178, 14, 41, -1.0, -0.4, 1, 0.5, 1.7, 0.2, 0.2,5)
				show_hudmessage(id,"%L",id,"SUICIDE_BOMB_ARMED")
			}
		}
		else{
			set_msg_block(gmsgDeathMsg,BLOCK_ONCE)
			user_kill(id)
			client_death(0, id, 0, 0, 0)
		}
	}
	else if (((p_data[id][P_RACE] == 9 && race9Options[4] == 6) || p_data[id][P_RACE] == 6) && p_data[id][P_ULTIMATE]==1 && !p_data_b[id][PB_ULTIMATEUSED]){
		new parm[2]
		parm[0]=id
		parm[1]=3

		entity_set_int(id,EV_INT_effects,EF_BRIGHTFIELD)
		set_task(2.0,"reset_godmode",TASK_RESETGOD+id,parm,2)

		new const MAXPLAYERS = get_global_int(GL_maxClients)

		for (new j = 1; j <= MAXPLAYERS; j++){
			if(p_data[j][P_ITEM]!=ITEM_NECKLACE)
				set_user_hitzones(j, id, 0)
		}

		#if MOD == 0
			Create_BarTime(id, 2, 0)
		#endif
		
		emit_sound(id,CHAN_STATIC, SOUND_VOODOO, 1.0, ATTN_NORM, 0, PITCH_NORM)

		p_data_b[id][PB_ULTIMATEUSED]=true
		
		icon_controller(id,ICON_FLASH)
	}
	else if (((p_data[id][P_RACE] == 9 && race9Options[4] == 5) || p_data[id][P_RACE] == 5) && p_data[id][P_ULTIMATE]==1 && !p_data_b[id][PB_ULTIMATEUSED]){	//Flame Strike
		fire_flamethrower(id) 
		p_data[id][P_FLAMECOUNT]++
		if(p_data[id][P_FLAMECOUNT]>5){
			p_data_b[id][PB_ULTIMATEUSED]=true
			icon_controller(id,ICON_HIDE)
			p_data[id][P_FLAMECOUNT]=0
		}
	}
	else if (((p_data[id][P_RACE] == 9 && race9Options[4] == 2) || p_data[id][P_RACE] == 2) && p_data[id][P_ULTIMATE]==1 && !p_data_b[id][PB_ULTIMATEUSED]){	// Teleport
		Ultimate_Teleport(id)
	}
	else if (!p_data_b[id][PB_ISSEARCHING] && ((p_data[id][P_RACE] == 9 && race9Options[4] == 3) || p_data[id][P_RACE] == 3) && p_data[id][P_ULTIMATE]==1 && !p_data_b[id][PB_ULTIMATEUSED]){		// Chain Lightning
		new parm[2]
		parm[0]=id
		parm[1]=ULTIMATESEARCHTIME
		lightsearchtarget(parm)
	}
	else if (!p_data_b[id][PB_ISSEARCHING] && ((p_data[id][P_RACE] == 9 && race9Options[4] == 4) || p_data[id][P_RACE] == 4) && p_data[id][P_ULTIMATE]==1 && !p_data_b[id][PB_ULTIMATEUSED]){		// Entangle Roots
		new parm[2]
		parm[0]=id
		parm[1]=ULTIMATESEARCHTIME
		searchtarget(parm)
	}
	else if (((p_data[id][P_RACE] == 9 && race9Options[4] == 7) || p_data[id][P_RACE] == 7) && p_data[id][P_ULTIMATE]==1 && !p_data_b[id][PB_ULTIMATEUSED]){	// Teleport
		Ultimate_Warden(id)
	}

	return PLUGIN_HANDLED
}

public searchtarget(parm[2]){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("searchtarget",parm[0])
	#endif

	new id = parm[0]

	if(!is_user_connected(id))
		return PLUGIN_CONTINUE

	new enemy, body
	get_user_aiming(id,enemy,body)
	if ( 0<enemy<=32 && !p_data_b[enemy][PB_STUNNED] && get_user_team(id)!=get_user_team(enemy) && p_data[enemy][P_ITEM]!=ITEM_NECKLACE && !p_data_b[enemy][PB_WARDENBLINK] && is_user_alive(id) && is_user_alive(enemy)){
		p_data_b[id][PB_ISSEARCHING]=false
		p_data_b[id][PB_ULTIMATEUSED]=true
		icon_controller(id,ICON_HIDE)

		Create_TE_BEAMFOLLOW(enemy, g_siTrail, 10, 5, 10, 108, 23, 255)

		emit_sound(id,CHAN_STATIC, SOUND_ENTANGLING, 1.0, ATTN_NORM, 0, PITCH_NORM)

		new waitparm[6]
		waitparm[0]=enemy
		waitparm[1]=100
		waitparm[5]=floatround(get_user_maxspeed(enemy))
		set_user_maxspeed(enemy,1.0)			
		waitstop(waitparm)
		
		p_data_b[enemy][PB_STUNNED]=true
		new cooldownparm[2]
		cooldownparm[0]=id

		p_data[id][P_ULTIMATEDELAY] = iCvar[FT_ULTIMATE_COOLDOWN]
		_WAR3_Ultimate_Delay(cooldownparm)	
	}
	else{
		p_data_b[id][PB_ISSEARCHING]=true
		icon_controller(id,ICON_FLASH)
		new counter = parm[1]
		while (counter >= 0){
			counter -= 10
			if (counter==0){
				emit_sound(id,CHAN_STATIC, SOUND_ULTIMATESCAN, 1.0, ATTN_NORM, 0, PITCH_NORM)
			}
		}			
		--parm[1]
		if (parm[1]>0 && get_user_health(id)>0){
			set_task(0.1,"searchtarget",TASK_SEARCHTARGET+id,parm,2)
		}else{
			p_data_b[id][PB_ISSEARCHING]=false
			icon_controller(id,ICON_SHOW)
		}
	}
	return PLUGIN_CONTINUE
}

public waitstop(parm[6]){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("waitstop",parm[0])
	#endif

	new id=parm[0]

	if(!is_user_connected(id))
		return PLUGIN_CONTINUE

	new origin[3]
	get_user_origin(id, origin)
	if (origin[0]==parm[2] && origin[1]==parm[3] && origin[2]==parm[4]){
		new normalspeed = parm[5]
		new resetparm[2]
		resetparm[0]=id
		resetparm[1]=normalspeed
		set_task(float(parm[1]/10),"reset_maxspeed",TASK_RESETSPEED+id,resetparm,2)
		new entangleparm[2]
		entangleparm[0]=parm[0]
		entangleparm[1]=parm[1]
		entangle(entangleparm)
	}
	else{
		parm[2]=origin[0]
		parm[3]=origin[1]
		parm[4]=origin[2]
		set_task(0.1,"waitstop",TASK_WAITSTOP+id,parm,6)
	}
	return PLUGIN_CONTINUE
}

public entangle(parm[2]){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("entangle",parm[0])
	#endif

	new id=parm[0]

	if(!is_user_connected(id))
		return PLUGIN_CONTINUE

	new life=parm[1]
	new radius = 20
	new counter = 0
	new origin[3]
	new x1
	new y1
	new x2
	new y2
	get_user_origin(id,origin)

	emit_sound(id,CHAN_STATIC, SOUND_ENTANGLING, 1.0, ATTN_NORM, 0, PITCH_NORM)

	new parm2[2]
	parm2[0]=id

	p_data[id][P_ULTIMATEDELAY] = iCvar[FT_ULTIMATE_COOLDOWN]
	_WAR3_Ultimate_Delay(parm2)


	while (counter<=7){
		if (counter==0 || counter==8)
			x1= -radius
		else if (counter==1 || counter==7)
			x1= -radius*100/141
		else if (counter==2 || counter==6)
			x1= 0
		else if (counter==3 || counter==5)
			x1= radius*100/141
		else if (counter==4)
			x1= radius
		if (counter<=4)
			y1 = sqrt(radius*radius-x1*x1)
		else
			y1 = -sqrt(radius*radius-x1*x1)
		++counter
		if (counter==0 || counter==8)
			x2= -radius
		else if (counter==1 || counter==7)
			x2= -radius*100/141
		else if (counter==2 || counter==6)
			x2= 0
		else if (counter==3 || counter==5)
			x2= radius*100/141
		else if (counter==4)
			x2= radius
		if (counter<=4)
			y2 = sqrt(radius*radius-x2*x2)
		else
			y2 = -sqrt(radius*radius-x2*x2)
		new height=16+2*counter
		new start[3], end[3]
		while (height > -40){
			
			start[0] = origin[0] + x1
			start[1] = origin[1]+y1
			start[2] = origin[2]+height
			end[0] = origin[0]+x2
			end[1] = origin[1]+y2
			end[2] = origin[2]+height+2
			
			Create_TE_BEAMPOINTS(start, end, g_siBeam4, 0, 0, life, 10, 5, 10, 108, 23, 255, 0)

			height -= 16
		}

	}
	return PLUGIN_CONTINUE
}

public lightsearchtarget(parm[2]){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("lightsearchtarget",parm[0])
	#endif

	new id = parm[0]

	if(!is_user_connected(id))
		return PLUGIN_CONTINUE

	new enemy, body
	get_user_aiming(id,enemy,body)
	if ( 0<enemy<=32 && get_user_team(id)!=get_user_team(enemy) && p_data[enemy][P_ITEM]!=ITEM_NECKLACE && !p_data_b[enemy][PB_WARDENBLINK] && is_user_alive(id) && is_user_alive(enemy)){
		p_data_b[id][PB_ULTIMATEUSED]=true
		icon_controller(id,ICON_HIDE)
		new linewidth = 80
		new damage = 50
		p_data_b[id][PB_ISSEARCHING]=false
		lightningeffect(id,enemy,linewidth,damage,id)
		new lightparm[4]
		lightparm[0]=enemy
		lightparm[1]=damage
		lightparm[2]=linewidth
		lightparm[3]=id
		set_task(0.2,"lightningnext",TASK_LIGHTNING+enemy,lightparm,4)
		new cooldownparm[2]
		cooldownparm[0]=id

		p_data[id][P_ULTIMATEDELAY] = iCvar[FT_ULTIMATE_COOLDOWN]
		_WAR3_Ultimate_Delay(cooldownparm)
	}
	else{
		p_data_b[id][PB_ISSEARCHING]=true
		icon_controller(id,ICON_FLASH)
		new counter = parm[1]
		while (counter >= 0){
			counter -= 10
			if (counter==0)
				emit_sound(id,CHAN_STATIC, "turret/tu_ping.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
		}
		--parm[1]	
		if (parm[1]>0 && get_user_health(id)>=0){
			set_task(0.1,"lightsearchtarget",TASK_LIGHTSEARCH+id,parm,2)
		}else{
			p_data_b[id][PB_ISSEARCHING]=false
			icon_controller(id,ICON_SHOW)
		}	
	}
	return PLUGIN_CONTINUE
}


public lightningnext(parm[4]){		// Chain Lightning
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("lightningnext",parm[0])
	#endif

	new id=parm[0]

	if(!is_user_connected(id))
		return PLUGIN_CONTINUE

	new caster=parm[3]
	new origin[3]
	get_user_origin(id, origin)
	new players[32]
	new teamname[32]
	get_user_team(id, teamname, 31)
	new numberofplayers
	get_players(players, numberofplayers,"ae",teamname)
	new i
	new targetid = 0
	new distancebetween = 0
	new targetorigin[3]
	new damage = parm[1]*2/3
	new linewidth = parm[2]*2/3
	new closestdistance = 0
	new closestid = 0
	for (i = 0; i < numberofplayers; ++i){
		targetid=players[i]
		if (get_user_team(id)==get_user_team(targetid) && is_user_alive(targetid) && is_user_alive(id)){
			get_user_origin(targetid,targetorigin)
			distancebetween=get_distance(origin,targetorigin)
			if (distancebetween < LIGHTNING_RANGE && !p_data_b[targetid][PB_LIGHTNINGHIT] && p_data[targetid][P_ITEM]!=ITEM_NECKLACE && !p_data_b[targetid][PB_WARDENBLINK]){
				if (distancebetween < closestdistance || closestid==0){
					closestdistance = distancebetween
					closestid = targetid
				}
			}
		}
	}

	if (closestid){
		lightningeffect(id,closestid,linewidth,damage,caster)
		parm[0]=targetid
		parm[1]=damage
		parm[2]=linewidth
		parm[3]=caster
		set_task(0.2,"lightningnext",TASK_LIGHTNINGNEXT+id,parm,4)
	}
	else{
		for (i = 0; i < numberofplayers; ++i){
			targetid=players[i]
			p_data_b[targetid][PB_LIGHTNINGHIT]=false
		}
	}
	return PLUGIN_CONTINUE
}

public lightningeffect(id,targetid,linewidth,damage,caster){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("lightningeffect",id)
	#endif

	p_data_b[targetid][PB_LIGHTNINGHIT]=true

	new parm[1]
	parm[0]=id
	icon_controller(id,ICON_HIDE)

	WAR3_damage(targetid, caster, damage, CSW_LIGHTNING, 0)

	if (get_user_armor(targetid)-damage<=0)
		set_user_armor(targetid,0)
	else
		set_user_armor(targetid,get_user_armor(targetid)-damage)

	Create_TE_BEAMENTS(id, targetid, g_sLightning, 0, 15, 10, linewidth, 10, 255, 255, 255, 255, 0)

	new origin[3]
	get_user_origin(targetid,origin)

	Create_TE_ELIGHT(targetid, origin, 100, 255, 255, 255, 10, 0)

	emit_sound(id,CHAN_STATIC, SOUND_LIGHTNING, 1.0, ATTN_NORM, 0, PITCH_NORM)

	return PLUGIN_CONTINUE
}

public func_spawn(parm[2]){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("func_spawn",parm[0])
	#endif

	if (endround){
		set_user_money(parm[0],get_user_money(parm[0])+itemcost2[0],1)
		return PLUGIN_HANDLED
	}

	new id = parm[0]

	if(!is_user_connected(id))
		return PLUGIN_CONTINUE

	if(get_user_team(id)==UNASSIGNED)
		return PLUGIN_CONTINUE

	p_data[id][P_ITEM]=0
	p_data[id][P_ITEM2]=0
	
	if (is_user_alive(id))
		return PLUGIN_CONTINUE

	new team[32]
	get_user_team(id,team,31)
	p_data_b[id][PB_PLAYERSPAWNED]=true
	icon_controller(id,ICON_SHOW)
	spawn(id)
	p_data_b[id][PB_SLOWED]=false
	p_data_b[id][PB_STUNNED]=false
	spawn(id)
	set_task(0.3,"spawn_player",TASK_SPAWNPLAYER+id,parm,2)
	set_task(0.5,"player_giveitems",TASK_GIVEITEMS+id,parm,2)
	give_item(id, "weapon_knife")
	new money = get_user_money(id)

	#if MOD == 0
		if (money < get_cvar_num("mp_startmoney"))
			set_user_money(id,get_cvar_num("mp_startmoney"),0)
	#endif
	#if MOD == 1
		if (money < iCvar[DOD_STARTMONEY])
			set_user_money(id,iCvar[DOD_STARTMONEY],0)

	#endif
	return PLUGIN_CONTINUE
}


public player_giveitems(parm[2]){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("player_giveitems",parm[0])
	#endif

	new id = parm[0]

	if(!is_user_connected(id))
		return PLUGIN_CONTINUE

	if(((p_data[id][P_RACE] == 9 && race9Options[4] == 7) || p_data[id][P_RACE] == 7) && p_data[id][P_ULTIMATE] && !p_data_b[id][PB_SPAWNEDFROMITEM])			// If spawned from vengeance
		set_user_health(id,50)
	else if (((p_data[id][P_RACE] == 9 && race9Options[1] == 4) || p_data[id][P_RACE] == 4) && p_data[id][P_SKILL1] && p_data_b[id][PB_EVADENEXTSHOT])	// Evasion
		set_user_health(id,1124)
	else if (((p_data[id][P_RACE] == 9 && race9Options[2] == 2) || p_data[id][P_RACE] == 2) && p_data[id][P_SKILL2])							// Devotion Aura
		set_user_health(id,p_devotion[p_data[id][P_SKILL2]-1])
	else
		set_user_health(id,100)													// All other cases

	check_blink(id)
	p_data_b[id][PB_GIVEITEMS]=true
	set_task(0.1, "weapon_controller", TASK_REINCARNATION+id, parm, 2)							// Give weapons back

	give_item(id, "item_suit")
	give_item(id, "weapon_knife")


	// The following code decides if pistols should be given
	#if MOD == 0
		if (!g_givePistol)
			return PLUGIN_CONTINUE
	#endif

	new wpnList[32] = 0, number = 0, foundGlock = false, foundUSP = false 
	get_user_weapons(id,wpnList,number)
	for (new i = 0;i < number;i++) { 
		if (wpnList[i] == CSW_GLOCK18) 
			foundGlock = true 
		if (wpnList[i] == CSW_USP) 
			foundUSP = true 
	} 
	if (get_user_team(id)==TS){
		if(foundGlock)
			return PLUGIN_CONTINUE
		else{
			give_item(id,"weapon_glock18")
			give_item(id,"ammo_9mm")
			give_item(id,"ammo_9mm")
			give_item(id,"ammo_9mm")
		}

	}
	if (get_user_team(id)==CTS){
		if(foundUSP)
			return PLUGIN_CONTINUE
		else{
			give_item(id,"weapon_usp")
			give_item(id,"ammo_45acp")
			give_item(id,"ammo_45acp")
			give_item(id,"ammo_45acp")
			give_item(id,"ammo_45acp")
			give_item(id,"ammo_45acp")
			give_item(id,"ammo_45acp")
			give_item(id,"ammo_45acp")
		}
	}

	return PLUGIN_CONTINUE

}

public spawn_player(parm[2]){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("spawn_player",parm[0])
	#endif

	new id = parm[0]

	if(!is_user_connected(id))
		return PLUGIN_CONTINUE

	p_data_b[id][PB_PLAYERSPAWNED]=true
	spawn(id)
	give_item(id, "item_suit")
	give_item(id, "weapon_knife")
	return PLUGIN_CONTINUE

}

#if MOD == 1
	public client_putinserver(id){
		p_data[id][P_MONEY] = iCvar[DOD_STARTMONEY]
		new parm[1]
		parm[0] = id
		_DOD_showMoney(parm)
	}
#endif

public client_connect(id){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("client_connect",id)
	#endif
	client_cmd(id, "hud_centerid 0")
	p_data[id][P_RACE] = 0
	p_data[id][P_SKILL1] = 0
	p_data[id][P_SKILL2] = 0
	p_data[id][P_SKILL3] = 0
	p_data[id][P_ULTIMATE] = 0
	p_data[id][P_LEVEL] = 0
	p_data[id][P_XP] = 0
	p_data[id][P_ITEM] = 0
	p_data[id][P_ITEM2] = 0
	p_data_b[id][PB_ISBURNING] = false
	p_data[id][P_SPECMODE] = false 

	new const MAXPLAYERS = get_global_int(GL_maxClients)

	// If a player has a helm, the new player shouldn't be able to hit him in the head
	if(id!=0){
		for (new j = 1; j <= MAXPLAYERS; j++){
			if(is_user_connected(j)){
				if(p_data[P_ITEM2][j] == ITEM_HELM)
					set_user_hitzones(id, j, 253)
			}
		}
	}

	#if MOD == 0
		p_data[id][P_HECOUNT] = 0
		p_data[id][P_FLASHCOUNT]=0
	#endif
	if (is_user_bot(id) && iCvar[MP_SAVEXP]){
		p_data[id][P_XP]=xplevel[floatround(random_float(0.0,3.16)*random_float(0.0,3.16))]
		p_data[id][P_RACE] = random_num(1,8)
		return PLUGIN_CONTINUE
	}
	return PLUGIN_CONTINUE
}


public client_disconnect(id){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("client_disconnect",id)
	#endif

	#if MOD == 0
		p_data[id][P_HECOUNT]=0
		p_data[id][P_FLASHCOUNT]=0
	#endif
	#if MOD == 1
		if(task_exists(TASK_MONEYLOOP+id))		// Remove the money task when a user disconnects
			remove_task(TASK_MONEYLOOP+id)
		p_data[id][P_MONEY] = 0
	#endif
	p_data[id][P_SPECMODE] = false
	p_data_b[id][PB_ISBURNING] = false
	p_data_b[id][PB_DIEDLASTROUND]=false
	new i=0
	for (i=0; i<32; ++i){		// Equipment Reincarnation
		savedweapons[id][i]=0
	}

	new const MAXPLAYERS = get_global_int(GL_maxClients)

	if(id!=0){
		for (new j = 1; j <= MAXPLAYERS; j++)
			set_user_hitzones(j, id, 255)
	}

	if (iCvar[MP_SAVEXP] && !is_user_bot(id) && p_data[id][P_RACE] && p_data[id][P_XP])
		write_xp_to_file(id)

	return PLUGIN_CONTINUE
}

public skills_info(id,saychat){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("skills_info",id)
	#endif

	if (warcraft3==false)
		return PLUGIN_CONTINUE

	if (iCvar[FT_CD]) {
		if (!WAR3_CD_installed(id)){
			client_print(id,print_chat,"%L",id,"CHEATING_DEATH_NOT_INSTALLED",g_MOD)
			return PLUGIN_CONTINUE
		}
	}

	new message[2048]
	new title[64], temp[1024]
	new pos = 0, len = 0, p[8]
	if(iCvar[FT_STEAM]){
		format(p,7,"<p>")
		len += format(message[len],1024-len,"<pre><body bgcolor=#000000><font color=#FFB000>")
		len += format(message[len],1024-len,"%L",id,"CLICK_HERE")
	}
	else{
		format(p,7,"^n^n")
	}
	new race_name[RACE_NAME_LENGTH]
	racename(p_data[id][P_RACE],id,race_name,RACE_NAME_LENGTH_F)

	format(title,63,"%L",id,"SKILLS_STRING",race_name)
	new race_skill[4][RACE_SKILL_LENGTH]
	for(new i=0;i<4;i++){
		raceskill(p_data[id][P_RACE],i+1,id,race_skill[i],RACE_SKILL_LENGTH_F)
	}

	if (p_data[id][P_RACE]==1){
		pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE1_SKILL1_INFO",race_skill[0],floatround(p_vampiric[0]*100),floatround(p_vampiric[1]*100),floatround(p_vampiric[2]*100),p)
		#if MOD == 1
			pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE1_SKILL2_INFO_DOD",race_skill[1],p)
		#else
			pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE1_SKILL2_INFO",race_skill[1],p)
		#endif
		pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE1_SKILL3_INFO",race_skill[2],p)
		pos+= format(temp[pos],1024-pos,"%L",id,"RACE1_SKILL4_INFO",race_skill[3])
	}
	else if (p_data[id][P_RACE]==2){
		pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE2_SKILL1_INFO",race_skill[0],p)
		pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE2_SKILL2_INFO",race_skill[1],p_devotion[0],p_devotion[1],p_devotion[2],p)
		pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE2_SKILL3_INFO",race_skill[2],floatround(p_bash[0]*100),floatround(p_bash[1]*100),floatround(p_bash[2]*100),p)
		if (iCvar[FT_BLINKENABLED])
			pos+= format(temp[pos],1024-pos,"%L",id,"RACE2_SKILL4_INFO_B",race_skill[3])
		else
			pos+= format(temp[pos],1024-pos,"%L",id,"RACE2_SKILL4_INFO_T",race_skill[3])
	}
	else if (p_data[id][P_RACE]==3){
		pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE3_SKILL1_INFO",race_skill[0],floatround(p_critical[0]*100),p)
		#if MOD == 1
			pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE3_SKILL2_INFO_DOD",race_skill[1],floatround(p_grenade[0]),floatround(p_grenade[1]),floatround(p_grenade[2]),p)
		#else
			pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE3_SKILL2_INFO",race_skill[1],floatround(p_grenade[0]),floatround(p_grenade[1]),floatround(p_grenade[2]),p)
		#endif
		pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE3_SKILL3_INFO",race_skill[2],floatround(p_ankh[0]*100),floatround(p_ankh[1]*100),floatround(p_ankh[2]*100),p)
		pos+= format(temp[pos],1024-pos,"%L",id,"RACE3_SKILL4_INFO",race_skill[3])
	}
	else if (p_data[id][P_RACE]==4){
		pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE4_SKILL1_INFO",race_skill[0],floatround(p_evasion[0]*100),floatround(p_evasion[1]*100),floatround(p_evasion[2]*100),p)
		pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE4_SKILL2_INFO",race_skill[1],floatround(p_thorns[0]*100),floatround(p_thorns[1]*100),floatround(p_thorns[2]*100),p)
		pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE4_SKILL3_INFO",race_skill[2],floatround(p_trueshot[0]*100),floatround(p_trueshot[1]*100),floatround(p_trueshot[2]*100),p)
		pos+= format(temp[pos],1024-pos,"%L",id,"RACE4_SKILL4_INFO",race_skill[3])
	}
	else if (p_data[id][P_RACE]==5){
		pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE5_SKILL1_INFO",race_skill[0],floatround(p_pheonix[0]*100),floatround(p_pheonix[1]*100),floatround(p_pheonix[2]*100),p)
		pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE5_SKILL2_INFO",race_skill[1],floatround(p_banish[0]*100),floatround(p_banish[1]*100),floatround(p_banish[2]*100),p)
		pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE5_SKILL3_INFO",race_skill[2],floatround(p_mana[0]*100),floatround(p_mana[1]*100),floatround(p_mana[2]*100),p)
		pos+= format(temp[pos],1024-pos,"%L",id,"RACE5_SKILL4_INFO",race_skill[3])
	}
	else if (p_data[id][P_RACE]==6){
		pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE6_SKILL1_INFO",race_skill[0],floatround(p_heal[0]),floatround(p_heal[1]),floatround(p_heal[2]),p)
		pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE6_SKILL2_INFO",race_skill[1],floatround(p_hex[0]*100),floatround(p_hex[1]*100),floatround(p_hex[2]*100),p)
		pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE6_SKILL3_INFO",race_skill[2],p_serpent[0],p_serpent[1],p_serpent[2],p)
		pos+= format(temp[pos],1024-pos,"%L",id,"RACE6_SKILL4_INFO",race_skill[3])
	}
	else if (p_data[id][P_RACE]==7){
		pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE7_SKILL1_INFO",race_skill[0],floatround(p_fan[0]*100),floatround(p_fan[1]*100),floatround(p_fan[2]*100),p)
		pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE7_SKILL2_INFO",race_skill[1],floatround(p_blink[0]*100),floatround(p_blink[1]*100),floatround(p_blink[2]*100),p)
		pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE7_SKILL3_INFO",race_skill[2],floatround(p_shadow[0]*100),floatround(p_shadow[1]*100),floatround(p_shadow[2]*100),p)
		pos+= format(temp[pos],1024-pos,"%L",id,"RACE7_SKILL4_INFO",race_skill[3])
	}
	else if (p_data[id][P_RACE]==8){
		pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE8_SKILL1_INFO",race_skill[0],p)
		pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE8_SKILL2_INFO",race_skill[1],floatround(p_spiked[0]*100),floatround(p_spiked[1]*100),floatround(p_spiked[2]*100),p)
		pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE8_SKILL3_INFO",race_skill[2],floatround(p_carrion[0]*100),floatround(p_carrion[1]*100),floatround(p_carrion[2]*100),p)
		pos+= format(temp[pos],1024-pos,"%L",id,"RACE8_SKILL4_INFO",race_skill[3])
	}
	else if (p_data[id][P_RACE]==9){
		switch(race9Options[1]){
			case 1: pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE1_SKILL1_INFO",race_skill[0],floatround(p_vampiric[0]*100),floatround(p_vampiric[1]*100),floatround(p_vampiric[2]*100),p)
			case 2: pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE2_SKILL1_INFO",race_skill[0],p)
			case 3: pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE3_SKILL1_INFO",race_skill[0],floatround(p_critical[0]*100),p)
			case 4:	pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE4_SKILL1_INFO",race_skill[0],floatround(p_evasion[0]*100),floatround(p_evasion[1]*100),floatround(p_evasion[2]*100),p)
			case 5: pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE5_SKILL1_INFO",race_skill[0],floatround(p_pheonix[0]*100),floatround(p_pheonix[1]*100),floatround(p_pheonix[2]*100),p)
			case 6: pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE6_SKILL1_INFO",race_skill[0],floatround(p_heal[0]),floatround(p_heal[1]),floatround(p_heal[2]),p)
			case 7: pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE7_SKILL1_INFO",race_skill[0],floatround(p_fan[0]*100),floatround(p_fan[1]*100),floatround(p_fan[2]*100),p)
			case 8: pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE8_SKILL1_INFO",race_skill[0],p)
		}
		switch(race9Options[2]){
			case 1:	{		
				#if MOD == 1
					pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE1_SKILL2_INFO_DOD",race_skill[1],p)
				#else
					pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE1_SKILL2_INFO",race_skill[1],p)
				#endif
			}
			case 2:	pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE2_SKILL2_INFO",race_skill[1],p_devotion[0],p_devotion[1],p_devotion[2],p)
			case 3:	pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE3_SKILL2_INFO",race_skill[1],floatround(p_grenade[0]),floatround(p_grenade[1]),floatround(p_grenade[2]),p)
			case 4:	pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE4_SKILL2_INFO",race_skill[1],floatround(p_thorns[0]*100),floatround(p_thorns[1]*100),floatround(p_thorns[2]*100),p)
			case 5:	pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE5_SKILL2_INFO",race_skill[1],floatround(p_banish[0]*100),floatround(p_banish[1]*100),floatround(p_banish[2]*100),p)
			case 6:	pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE6_SKILL2_INFO",race_skill[1],floatround(p_hex[0]*100),floatround(p_hex[1]*100),floatround(p_hex[2]*100),p)
			case 7:	pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE7_SKILL2_INFO",race_skill[1],floatround(p_blink[0]*100),floatround(p_blink[1]*100),floatround(p_blink[2]*100),p)
			case 8:	pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE8_SKILL2_INFO",race_skill[1],floatround(p_spiked[0]*100),floatround(p_spiked[1]*100),floatround(p_spiked[2]*100),p)
		}
		switch(race9Options[3]){
			case 1:	pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE1_SKILL3_INFO",race_skill[2],p)
			case 2:	pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE2_SKILL3_INFO",race_skill[2],floatround(p_bash[0]*100),floatround(p_bash[1]*100),floatround(p_bash[2]*100),p)
			case 3:	pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE3_SKILL3_INFO",race_skill[2],floatround(p_ankh[0]*100),floatround(p_ankh[1]*100),floatround(p_ankh[2]*100),p)
			case 4:	pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE4_SKILL3_INFO",race_skill[2],floatround(p_trueshot[0]*100),floatround(p_trueshot[1]*100),floatround(p_trueshot[2]*100),p)
			case 5:	pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE5_SKILL3_INFO",race_skill[2],floatround(p_mana[0]*100),floatround(p_mana[1]*100),floatround(p_mana[2]*100),p)
			case 6:	pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE6_SKILL3_INFO",race_skill[2],p_serpent[0],p_serpent[1],p_serpent[2],p)
			case 7:	pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE7_SKILL3_INFO",race_skill[2],floatround(p_shadow[0]*100),floatround(p_shadow[1]*100),floatround(p_shadow[2]*100),p)
			case 8:	pos+= format(temp[pos],1024-pos,"%L%s",id,"RACE8_SKILL3_INFO",race_skill[2],floatround(p_carrion[0]*100),floatround(p_carrion[1]*100),floatround(p_carrion[2]*100),p)
		}
		switch(race9Options[4]){
			case 1:	pos+= format(temp[pos],1024-pos,"%L",id,"RACE1_SKILL4_INFO",race_skill[3])
			case 2:{
				if (iCvar[FT_BLINKENABLED])
					pos+= format(temp[pos],1024-pos,"%L",id,"RACE2_SKILL4_INFO_B",race_skill[3])
				else
					pos+= format(temp[pos],1024-pos,"%L",id,"RACE2_SKILL4_INFO_T",race_skill[3])
			}
			case 3:		pos+= format(temp[pos],1024-pos,"%L",id,"RACE3_SKILL4_INFO",race_skill[3])
			case 4:		pos+= format(temp[pos],1024-pos,"%L",id,"RACE4_SKILL4_INFO",race_skill[3])
			case 5:		pos+= format(temp[pos],1024-pos,"%L",id,"RACE5_SKILL4_INFO",race_skill[3])
			case 6:		pos+= format(temp[pos],1024-pos,"%L",id,"RACE6_SKILL4_INFO",race_skill[3])
			case 7:		pos+= format(temp[pos],1024-pos,"%L",id,"RACE7_SKILL4_INFO",race_skill[3])
			case 8:		pos+= format(temp[pos],1024-pos,"%L",id,"RACE8_SKILL4_INFO",race_skill[3])
		}


	}
	else{
		console_print(id,"%L",id,"SELECT_RACE_BEFORE_SKILLS")
		return PLUGIN_HANDLED
	}

	if(p_data[id][P_RACE]!=0){
		len += format(message[len],1024-len,temp)
	}

	new race_info[128]
	format(race_info,127,"%L",id,"RACE_INFORMATION")
	show_motd(id,message,race_info)
	if (saychat==1)
		return PLUGIN_CONTINUE
	return PLUGIN_HANDLED
}

public war3_vote(id,saychat) {
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("war3_vote",id)
	#endif

	if (iCvar[FT_CD]) {
		if (!WAR3_CD_installed(id)){
			client_print(id,print_chat,"%L",id,"CHEATING_DEATH_NOT_INSTALLED",g_MOD)
			return PLUGIN_CONTINUE
		}
	}

	if (iCvar[SV_ALLOWWAR3VOTE]==0){
		client_print(id,print_center,"%L",id,"VOTING_NOT_ALLOWED")
		return PLUGIN_CONTINUE
	}
	new name[32], auth[32], logmessage[128]
	get_user_name(id,name,31)
	get_user_authid(id,auth,31)

	format(logmessage,127,"%L",LANG_SERVER,"INITIATED_A_WAR3_VOTE",name,auth)
	log_message(logmessage)
	format(logmessage,127,"%L",LANG_PLAYER,"INITIATED_A_WAR3_VOTE",name,auth)
	console_print(0,logmessage)

	if (voting > get_gametime()){
		if(saychat==1)
			client_print(id,print_notify,"%L",id,"ALREADY_ONE_VOTING")
		else
			console_print(id,"%L",id,"ALREADY_ONE_VOTING")
		return PLUGIN_HANDLED
	}
	if (voting > 0.0 && voting + get_cvar_float("amx_vote_delay") > get_gametime()) {
		if(saychat==1)
			client_print(id,print_notify,"%L",id,"VOTING_NOT_ALLOWED_THIS_TIME")
		else
			console_print(id,"%L",id,"VOTING_NOT_ALLOWED_THIS_TIME")
		return PLUGIN_HANDLED
	}

	new keys = (1<<0)|(1<<1)
	new menu_msg[256]
	 
	if (warcraft3==false)
		format(menu_msg,255,"\y%L",id,"ENABLE_WAR3_PLUGIN")
	else
		format(menu_msg,255,"\y%L",id,"DISABLE_WAR3_PLUGIN")	

	new Float:vote_time = get_cvar_float("amx_vote_time") + 2.0
	voting = get_gametime() + vote_time
	vote_ratio = fCvar[AMX_VOTEWAR3_RATIO]
	show_menu(0,keys,menu_msg,floatround(vote_time))
	set_task(vote_time,"check_votes",TASK_CHECKVOTES)
	console_print(id,"%L...",id,"VOTING_HAS_STARTED")
	option=0
	if (saychat==1)
		return PLUGIN_CONTINUE
	return PLUGIN_HANDLED
}

public vote_count(id,key){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("vote_count",id)
	#endif
	if (fCvar[AMX_VOTE_ANSWERS]) {
		new name[32]
		get_user_name(id,name,31)
		new voted[16], against[16],for_string[16]
		format(for_string,15,"%L",id,"FOR_STRING")
		format(against,15,"%L",id,"AGAINST_STRING")
		format(voted,15,"%L",id,"VOTED_STRING")
		client_print(0,print_chat,"* %s %s %s",name,voted,key ? against : for_string )
	}
	if (!key) ++option
	return PLUGIN_HANDLED
}

public check_votes() { 
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("check_votes",0)
	#endif
	new status[32]
	new players[32], inum
	get_players(players,inum,"c")
	new Float:result_v = inum ? (float(option) / float(inum)) : 0.0
	if (result_v<vote_ratio){
		client_print(0,print_chat,"* %L",LANG_PLAYER,"VOTING_FAILED_STRING", option, inum-option,vote_ratio)
		return PLUGIN_HANDLED
	}
	if (warcraft3==false){
		set_cvar_num("sv_warcraft3",1)
		format(status,31,"%L",LANG_PLAYER,"ENABLED")
	}
	else{
		set_cvar_num("sv_warcraft3",0)
		format(status,31,"%L",LANG_PLAYER,"DISABLED")
	}
	client_print(0,print_chat,"%L",LANG_PLAYER,"VOTING_SUCCESSFUL",result_v,vote_ratio,status)
	return PLUGIN_HANDLED
} 

public save_xp_info(id,show){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("save_xp_info",id)
	#endif

	if (iCvar[MP_SAVEXP]){
		if(show)
			client_print(id,print_chat, "[%s] XP saved.",g_MOD)
		write_xp_to_file(id)
	}	
	else if (show)
		client_print(id,print_chat,"%L",id,"XP_IS_NOT_SAVED", g_MOD)
	
	return PLUGIN_CONTINUE
}

public check_war3(){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("check_war3",0)
	#endif

	if (get_cvar_num("sv_warcraft3")==0)
		warcraft3=false
	else
		warcraft3=true

	return PLUGIN_CONTINUE
}

public write_all(){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("write_all",0)
	#endif

	if (warcraft3){
		new players[32], numofplayers, id, i
		get_players(players, numofplayers)
		if(iCvar[SV_MYSQL]){
			if (iCvar[SV_MYSQL_SAVE_END_ROUND]){
				for (i=0; i<numofplayers; i++){
					id = players[i]
					write_xp_to_file(id)
				}
			}
		}
		else{
			for (i=0; i<numofplayers; i++){
				id = players[i]
				write_xp_to_file(id)
			}
		}
	}
	return PLUGIN_CONTINUE
}

public write_xp_to_file(id){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("write_xp_to_file",id)
	#endif

	if (is_user_bot(id) || !iCvar[MP_SAVEXP])
		return PLUGIN_CONTINUE

	if(p_data[id][P_RACE]==0)
		return PLUGIN_CONTINUE

	new playerid[32], playername[32], timet[32], ip[32]

	if (iCvar[SV_MYSQL]){
		new mquery[1024]
		get_user_name(id,playername,31)
		get_user_authid(id,playerid,31)
		get_user_ip(id,ip,31) 

		if(iCvar[FT_SAVEBY]==0)						// Save by steam ID
			format(mquery, 1023, "REPLACE INTO `%s` SET playerid='%s',playername='%s',xp='%d',race='%d',skill1='%d',skill2='%d',skill3='%d',skill4='%d'",mysqltablename,playerid,playername,p_data[id][P_XP], p_data[id][P_RACE],p_data[id][P_SKILL1],p_data[id][P_SKILL2],p_data[id][P_SKILL3],p_data[id][P_ULTIMATE])
		else if(iCvar[FT_SAVEBY]==1)					// Save by IP address
			format(mquery, 1023, "REPLACE INTO `%s` SET playerid='%s',playername='%s',xp='%d',race='%d',skill1='%d',skill2='%d',skill3='%d',skill4='%d'",mysqltablename,ip,playername,p_data[id][P_XP], p_data[id][P_RACE],p_data[id][P_SKILL1],p_data[id][P_SKILL2],p_data[id][P_SKILL3],p_data[id][P_ULTIMATE])
		else if(iCvar[FT_SAVEBY]==2)					// Save by Player name
			format(mquery, 1023, "REPLACE INTO `%s` SET playerid='%s',playername='%s',xp='%d',race='%d',skill1='%d',skill2='%d',skill3='%d',skill4='%d'",mysqltablename,playername,playername,p_data[id][P_XP], p_data[id][P_RACE],p_data[id][P_SKILL1],p_data[id][P_SKILL2],p_data[id][P_SKILL3],p_data[id][P_ULTIMATE])

		new Result:ret = dbi_query(mysql, mquery)

		if (ret < RESULT_NONE) {
			new err[255]
			new errNum = dbi_error(mysql, err, 254)
			server_print("[%s] DBI write_xp error: %s|%d", g_MOD, err, errNum)
			log_amx("[%s] DBI write_xp error: %s|%d", g_MOD, err, errNum)
			return 1
		} 	

	}
	else{			// Save it to a vault :)
		new temp[128], string[512]
		get_time("%m %d %H %M",timet,31)
		get_user_authid(id,playerid,31)
		get_user_name(id,playername,31)
		get_user_ip(id,ip,31)
		format(string,511,"%s %d %d %d %d %d %d %s %s %s",playerid,p_data[id][P_XP],p_data[id][P_RACE],p_data[id][P_SKILL1],p_data[id][P_SKILL2],p_data[id][P_SKILL3],p_data[id][P_ULTIMATE],playername,ip,timet)

		if(iCvar[FT_SAVEBY]==0)						// Save by steam ID
			format(temp,127,"%s_%d",playerid,p_data[id][P_RACE])
		else if(iCvar[FT_SAVEBY]==1)					// Save by IP address
			format(temp,127,"%s_%d",ip,p_data[id][P_RACE])
		else if(iCvar[FT_SAVEBY]==2)					// Save by Player name
			format(temp,127,"%s_%d",playername,p_data[id][P_RACE])

		set_vaultdata(temp,string)
	}
	return PLUGIN_CONTINUE
}

public get_xp_from_file(id,returnrace){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("get_xp_from_file",id)
	#endif

	if (!iCvar[MP_SAVEXP])
		return PLUGIN_CONTINUE

	if (!id)
		return PLUGIN_CONTINUE

	new mquery[1024]

	new playerid[32], playername[32], ip[32]
	new xp[8], race[2], skill1[2], skill2[2], skill3[2], skill4[2]
	new racexp[9]={0,0,0,0,0,0,0,0,0}
	get_user_name(id,playername,31)
	get_user_authid(id,playerid,31)
	get_user_ip(id,ip,31) 

	if (iCvar[SV_MYSQL]){
		if (returnrace){
			if(iCvar[FT_SAVEBY]==0)						// Save by steam ID
				format(mquery, 1023, "SELECT * FROM `%s` WHERE playerid='%s'",mysqltablename,playerid)
			else if(iCvar[FT_SAVEBY]==1)					// Save by IP address
				format(mquery, 1023, "SELECT * FROM `%s` WHERE playerid='%s'",mysqltablename,ip)
			else if(iCvar[FT_SAVEBY]==2)					// Save by Player name
				format(mquery, 1023, "SELECT * FROM `%s` WHERE playerid='%s'",mysqltablename,playername)

			new Result:res = dbi_query(mysql, mquery)

			if (res < RESULT_NONE) {
				new err[255]
				new errNum = dbi_error(mysql, err, 254)
				server_print("[%s] DBI get_xp error1: %s|%d", g_MOD, err, errNum)
				log_amx("[%s] DBI get_xp error1: %s|%d", g_MOD, err, errNum)
				return PLUGIN_CONTINUE
			}
		#if DEBUG
			server_print("[%s] DBI get_xp Result handle: %d", g_MOD, res)
		#endif
			while (res && dbi_nextrow(res)>0) {
				dbi_result(res, "xp", xp, 7)
				dbi_result(res, "race", race, 1)
				if (str_to_num(race)>=1 && str_to_num(race)<=9)
					racexp[str_to_num(race)-1] = str_to_num(xp)
			#if DEBUG
				server_print("[%s] get_xp result: Race:%s, XP:%s", g_MOD, race, xp)
			#endif
			}

			dbi_free_result(res) 

			if (p_data[id][P_RACE])
				racexp[p_data[id][P_RACE]-1]=p_data[id][P_XP]

			WAR3_select_race(id, racexp)
		}
		else{
			if(iCvar[FT_SAVEBY]==0)						// Save by steam ID
				format(mquery, 1023, "SELECT * FROM `%s` WHERE playerid='%s' AND race='%d'",mysqltablename,playerid,p_data[id][P_RACE])
			else if(iCvar[FT_SAVEBY]==1)					// Save by IP address
				format(mquery, 1023, "SELECT * FROM `%s` WHERE playerid='%s' AND race='%d'",mysqltablename,ip,p_data[id][P_RACE])
			else if(iCvar[FT_SAVEBY]==2)					// Save by Player name
				format(mquery, 1023, "SELECT * FROM `%s` WHERE playerid='%s' AND race='%d'",mysqltablename,playername,p_data[id][P_RACE])

			new Result:res = dbi_query(mysql, mquery)

			if (res < RESULT_NONE) {
				new err[255]
				new errNum = dbi_error(mysql, err, 254)
				server_print("[%s] DBI get_xp error2: %s|%d", g_MOD, err, errNum)
				log_amx("[%s] DBI get_xp error2: %s|%d", g_MOD, err, errNum)
				
				return PLUGIN_CONTINUE
			}
		#if DEBUG
			server_print("[%s] DBI get_xp Result handle: %d", g_MOD, res)
		#endif

			if (res && dbi_nextrow(res)>0){
				dbi_result(res, "xp", xp, 7)
				dbi_result(res, "skill1", skill1, 1)
				dbi_result(res, "skill2", skill2, 1)
				dbi_result(res, "skill3", skill3, 1)
				dbi_result(res, "skill4", skill4, 1)				

			#if DEBUG
				server_print("[%s] get_xp result: Race:%s,  XP:%s, skill1:%d, skill2:%s, skill3:%s, skill4:%s", g_MOD, race, xp, skill1, skill2, skill3, skill4)
			#endif
				dbi_free_result(res) 

				p_data[id][P_XP]=str_to_num(xp)
				p_data[id][P_SKILL1]=str_to_num(skill1)
				p_data[id][P_SKILL2]=str_to_num(skill2)
				p_data[id][P_SKILL3]=str_to_num(skill3)
				p_data[id][P_ULTIMATE]=str_to_num(skill4)
				WAR3_Display_Level(id,DISPLAYLEVEL_SHOWRACE)
			}
			else{
				p_data[id][P_XP]=0
				p_data[id][P_SKILL1]=0
				p_data[id][P_SKILL2]=0
				p_data[id][P_SKILL3]=0
				p_data[id][P_ULTIMATE]=0
				WAR3_Display_Level(id,DISPLAYLEVEL_SHOWRACE)
			}
		}
	}
	else{			// Get info from a vault
		new info[512], temp[128]
		new i, attempt
		if (returnrace)
		{
			for(i=1;i<9;i++){
				format(xp,7,"")
				format(race,1,"")
				format(temp,127,"")

				if(iCvar[FT_SAVEBY]==0)			// Get info by steam ID
					format(temp,127,"%s_%d",playerid,i)
				else if(iCvar[FT_SAVEBY]==1)		// Get info by IP address
					format(temp,127,"%s_%d",ip,i)
				else if(iCvar[FT_SAVEBY]==2)		// Get info by Player name
					format(temp,127,"%s_%d",playername,i)


				attempt = get_vaultdata(temp,info,511)
				parse(info, playerid,31, xp,7, race,1, skill1,1, skill2,1, skill3,1, skill4,1)
				if (str_to_num(race)>=1 && str_to_num(race)<=9)
					racexp[str_to_num(race)-1] = str_to_num(xp)
			}
			if (p_data[id][P_RACE])
				racexp[p_data[id][P_RACE]-1]=p_data[id][P_XP]

			WAR3_select_race(id, racexp)
		}
		else{

			if(iCvar[FT_SAVEBY]==0)			// Get info by steam ID
				format(temp,127,"%s_%d",playerid,p_data[id][P_RACE])
			else if(iCvar[FT_SAVEBY]==1)		// Get info by IP address
				format(temp,127,"%s_%d",ip,p_data[id][P_RACE])
			else if(iCvar[FT_SAVEBY]==2)		// Get info by Player name
				format(temp,127,"%s_%d",playername,p_data[id][P_RACE])

			attempt = get_vaultdata(temp,info,511)
			if (attempt){
				parse(info, playerid,31, xp,7, race,1, skill1,1, skill2,1, skill3,1, skill4,1)
				p_data[id][P_XP]=str_to_num(xp)
				p_data[id][P_SKILL1]=str_to_num(skill1)
				p_data[id][P_SKILL2]=str_to_num(skill2)
				p_data[id][P_SKILL3]=str_to_num(skill3)
				p_data[id][P_ULTIMATE]=str_to_num(skill4)
				WAR3_Display_Level(id,DISPLAYLEVEL_SHOWRACE)
			}
			else{
				p_data[id][P_XP]=0
				p_data[id][P_SKILL1]=0
				p_data[id][P_SKILL2]=0
				p_data[id][P_SKILL3]=0
				p_data[id][P_ULTIMATE]=0
				WAR3_Display_Level(id,DISPLAYLEVEL_SHOWRACE)
			}
		}
	}
	return PLUGIN_CONTINUE
}

public set_mysql(){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("set_mysql",0)
	#endif

	if (iCvar[SV_MYSQL]){
		get_cvar_string("sv_mysqltablename",mysqltablename,63)
		new mhost[64], muser[32], mpass[32], mdb[32], primarykey[128]
		new mquery[512]
		format (mquery, 511, "CREATE TABLE IF NOT EXISTS `%s` ( `playerid` VARCHAR(35) NOT NULL, `playername` VARCHAR(35) NOT NULL, `xp` INT(11) NOT NULL, `race` TINYINT(4) NOT NULL, `skill1` TINYINT(4), `skill2` TINYINT(4), `skill3` TINYINT(4), `skill4` TINYINT(4), `time` TIMESTAMP( 14 ) NOT NULL, PRIMARY KEY (playerid,race))",mysqltablename)

		get_cvar_string("FT_mysql_host",mhost,63)
		get_cvar_string("FT_mysql_user",muser,31)
		get_cvar_string("FT_mysql_pass",mpass,31)
		get_cvar_string("FT_mysql_db",mdb,31)

		new err[255], errNum = 0
		mysql = dbi_connect(mhost,muser,mpass,mdb)
		if (mysql < SQL_OK) {
			errNum = dbi_error(mysql, err, 254)
			server_print("[%s] DBI set_mysql error1: %s|%d", g_MOD, err, errNum)
			log_amx("[%s] DBI set_mysql error1: %s|%d", g_MOD, err, errNum)

			set_task(25.0, "set_mysql", TASK_SETMYSQL)
			return 1
		} 
	#if DEBUG
		server_print("[%s] Connection handle: %d", g_MOD, mysql)
	#endif
		new Result:ret = dbi_query(mysql, mquery)

		if (ret < RESULT_NONE) {
			errNum = dbi_error(mysql, err, 254)
			server_print("[%s] DBI set_mysql error2: %s|%d", g_MOD, err, errNum)
			log_amx("[%s] DBI set_mysql error2: %s|%d", g_MOD, err, errNum)
			return 1
		}

		format(mquery, 511, "show index from `%s`", mysqltablename)

		new Result:res = dbi_query(mysql, mquery)

		if (res <= RESULT_NONE) {
			errNum = dbi_error(mysql, err, 254)
			server_print("[%s] DBI set_mysql error3: %s|%d", g_MOD, err, errNum)
			log_amx("[%s] DBI set_mysql error3: %s|%d", g_MOD, err, errNum)
			return 1
		}

	#if DEBUG
		server_print("[%s] DBI set_mysql Result handle: %d", g_MOD, res)
	#endif

		while (res && dbi_nextrow(res)>0) {
			dbi_result(res, "Column_name", primarykey, 127)
		#if DEBUG
			server_print("[%s] DBI set_mysql result: %s", g_MOD, primarykey)
		#endif
		}

		dbi_free_result(res)

		if (contain(primarykey,"playerid")){	// contain() returns 0 if the two strings match exactly
			format(mquery, 511, "ALTER TABLE `%s` DROP PRIMARY KEY , ADD PRIMARY KEY ( `playerid` , `race` )", mysqltablename)
			new Result:ret2 = dbi_query(mysql, mquery)
			if (ret2 < RESULT_NONE) {
				errNum = dbi_error(mysql, err, 254)
				server_print("[%s] DBI set_mysql error4: %s|%d", g_MOD, err, errNum)
				log_amx("[%s] DBI set_mysql error4: %s|%d", g_MOD, err, errNum)
				return 1
			}
		}
	}

	return PLUGIN_CONTINUE
}

public plugin_end(){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("plugin_end",0)
	#endif

	if (!warcraft3 || !iCvar[MP_SAVEXP] || g_mapDisabled)
		return PLUGIN_CONTINUE
	
	write_all()

	if (iCvar[SV_MYSQL_AUTO_PRUNING] && iCvar[SV_MYSQL] && iCvar[MP_SAVEXP]){
		new mquery[1024]
		new currentHour[3]  
		new currentMin[3]      			
		
		get_time("%H",currentHour,2)
		get_time("%M",currentMin,2)
		
		// At 5:36 AM until 5:59 AM a mapchange will trigger an auto-prune.
		if((str_to_num(currentHour) == 5) && (str_to_num(currentMin) > 35 )){
				
			// Timestamp format: 20030912122142
			// Y = 2003 M = 09 D = 12 H = 12 M = 21 S = 42	
			format(mquery, 1023, "DELETE FROM `%s` WHERE `time` + %d < now()",mysqltablename, iCvar[SV_DAYSBEFOREDELETE] * 1000000)

			new Result:ret = dbi_query(mysql, mquery)

			if (ret < RESULT_NONE) {
				new err[255]
				new errNum = dbi_error(mysql, err, 254)
				server_print("[%s] DBI prune error: %s|%d", g_MOD, err, errNum)
				log_amx("[%s] DBI prune error: %s|%d", g_MOD, err, errNum)
				return 1
			} 		
		}
	}
	if (iCvar[SV_MYSQL]){
		dbi_close(mysql)
	}
	return PLUGIN_CONTINUE
}

public shopmenu(id){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("shopmenu",id)
	#endif

	if (warcraft3==false)
		return PLUGIN_CONTINUE

	if (iCvar[FT_CD]) {
		if (!WAR3_CD_installed(id)){
			client_print(id,print_chat,"%L",id,"CHEATING_DEATH_NOT_INSTALLED",g_MOD)
			return PLUGIN_CONTINUE
		}
	}

	if(iCvar[FT_COMPETITIVE]){
		if (!is_user_alive(id)){
			client_print(id,print_center,"%L",id,"NOT_BUY_ITEMS_WHEN_DEAD")
			return PLUGIN_HANDLED
		}
		#if MOD == 0
			else if(!g_buyTime){
				new Float:thetime = get_cvar_float("mp_buytime")*60.0
				client_print(id,print_center,"%L",id,"SECONDS_HAVE_PASSED_CANT_BUY",thetime)
				return PLUGIN_HANDLED
			}
			else if(!cs_get_user_buyzone(id)){
				client_print(id,print_center,"%L",id,"MUST_BE_IN_BUYZONE")
				return PLUGIN_HANDLED
			}
		#endif
	}
	new pos = 0
	new keys = (1<<0|1<<1|1<<2|1<<3|1<<4|1<<5|1<<6|1<<7|1<<8|1<<9)
	new menu_body[512]

	pos += format(menu_body[pos], 511-pos, "%L",id,"MENU_BUY_ITEM")
	
	new item_name[9][ITEM_NAME_LENGTH]
	for(new i=0;i<9;i++){
		itemname(i+1,id,item_name[i],ITEM_NAME_LENGTH_F)
	}

	for (new i = 0; i<9; i++){
		pos += format(menu_body[pos], 511-pos, "\w%d. %s\y\R%d^n",i+1,item_name[i],itemcost[i])
	}
	pos += format(menu_body[pos], 511-pos, "^n\w0. %L",id,"EXIT_STRING")


	show_menu(id,keys,menu_body,-1)
	return PLUGIN_HANDLED
}

public shopmenu2(id){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("shopmenu2",id)
	#endif

	if (warcraft3==false)
		return PLUGIN_CONTINUE

	if(iCvar[FT_RACES] < 5)
		return PLUGIN_CONTINUE

	if (iCvar[FT_CD]) {
		if (!WAR3_CD_installed(id)){
			client_print(id,print_chat,"%L",id,"CHEATING_DEATH_NOT_INSTALLED",g_MOD)
			return PLUGIN_CONTINUE
		}
	}

	if(iCvar[FT_COMPETITIVE]){
		if (!is_user_alive(id)){
			client_print(id,print_center,"%L",id,"NOT_BUY_ITEMS_WHEN_DEAD")
			return PLUGIN_HANDLED
		}
		#if MOD == 0
			else if(!g_buyTime){
				new Float:thetime = get_cvar_float("mp_buytime")*60.0
				client_print(id,print_center,"%L",id,"SECONDS_HAVE_PASSED_CANT_BUY",thetime)
				return PLUGIN_HANDLED
			}
			else if(!cs_get_user_buyzone(id)){
				client_print(id,print_center,"%L",id,"MUST_BE_IN_BUYZONE")
				return PLUGIN_HANDLED
			}
		#endif
	}
	new pos = 0
	new keys = (1<<0|1<<1|1<<2|1<<3|1<<4|1<<5|1<<6|1<<7|1<<8|1<<9)
	new menu_body[512]

	pos += format(menu_body[pos], 511-pos, "%L",id,"MENU_BUY_ITEM2")

	new item_name2[9][ITEM_NAME_LENGTH]
	for(new i=0;i<9;i++){
		itemname2(i+1,id,item_name2[i],ITEM_NAME_LENGTH_F)
	}

	for (new i = 0; i<9; i++){
		pos += format(menu_body[pos], 511-pos, "\w%d. %s\y\R%d^n",i+1,item_name2[i],itemcost2[i])
	}

	pos += format(menu_body[pos], 511-pos, "^n\w0. %L",id,"EXIT_STRING")

	show_menu(id,keys,menu_body,-1)
	return PLUGIN_HANDLED
}

public buy_item(id,key){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("buy_item",id)
	#endif

	if (warcraft3==false)
		return PLUGIN_CONTINUE

	if (key==9)
		return PLUGIN_HANDLED

	if(iCvar[FT_COMPETITIVE]){
		if (!is_user_alive(id)){
			client_print(id,print_center,"%L",id,"NOT_BUY_ITEMS_WHEN_DEAD")
			return PLUGIN_HANDLED
		}
		#if MOD == 0
			else if(!g_buyTime){
				new Float:thetime = get_cvar_float("mp_buytime")*60.0
				client_print(id,print_center,"%L",id,"SECONDS_HAVE_PASSED_CANT_BUY",thetime)
				return PLUGIN_HANDLED
			}
			else if(!cs_get_user_buyzone(id)){
				client_print(id,print_center,"%L",id,"MUST_BE_IN_BUYZONE")
				return PLUGIN_HANDLED
			}
		#endif
	}

	if (!is_user_alive(id) && (key==7 || key==6 || key==5 || key==4 || key==3 || key==2 || key==1)){
		client_print(id,print_center,"%L",id,"NOT_PURCHASE_WHEN_DEAD")
		return PLUGIN_CONTINUE
	}
	new usermoney = get_user_money(id)
	if(key==p_data[id][P_ITEM]-1 && key!=ITEM_TOME-1){
		client_print(id,print_center,"%L",id,"ALREADY_OWN_THAT_ITEM")
		return PLUGIN_HANDLED
	}
	else if (usermoney<itemcost[key]){
		client_print(id,print_center,"%L",id,"INSUFFICIENT_FUNDS")
		return PLUGIN_HANDLED
	}
	else if (key==ITEM_TOME-1){
		set_user_money(id,usermoney-itemcost[key],1)
		XP_give(id,iCvar[XPBONUS])
		emit_sound(id,CHAN_STATIC, "warcraft3/Tomes.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)

		WAR3_Display_Level(id,DISPLAYLEVEL_NONE)
		return PLUGIN_HANDLED
	}
	else{
		set_user_money(id,usermoney-itemcost[key],1)
		if (p_data[id][P_ITEM]==ITEM_HEALTH)		// Remove health bonus after buying new item
			set_user_health(id,get_user_health(id)-iCvar[FT_HEALTH_BONUS])
		p_data[id][P_ITEM]=key+1
		if (p_data[id][P_ITEM]==ITEM_HEALTH)		// Give health bonus for buying periapt of health
			set_user_health(id,get_user_health(id)+iCvar[FT_HEALTH_BONUS])
	}

	emit_sound(id,CHAN_STATIC, SOUND_PICKUPITEM, 1.0, ATTN_NORM, 0, PITCH_NORM)

	WAR3_Display_Level(id,DISPLAYLEVEL_NONE)

	return PLUGIN_HANDLED
}

public buy_item2(id,key){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("buy_item2",id)
	#endif

	if (warcraft3==false)
		return PLUGIN_CONTINUE

	if (key==9)
		return PLUGIN_HANDLED

	if(iCvar[FT_COMPETITIVE]){
		if (!is_user_alive(id)){
			client_print(id,print_center,"%L",id,"NOT_BUY_ITEMS_WHEN_DEAD")
			return PLUGIN_HANDLED
		}
		#if MOD == 0
			else if(!g_buyTime){
				new Float:thetime = get_cvar_float("mp_buytime")*60.0
				client_print(id,print_center,"%L",id,"SECONDS_HAVE_PASSED_CANT_BUY",thetime)
				return PLUGIN_HANDLED
			}
			else if(!cs_get_user_buyzone(id)){
				client_print(id,print_center,"%L",id,"MUST_BE_IN_BUYZONE")
				return PLUGIN_HANDLED
			}
		#endif
	}
	if (!is_user_alive(id) && (key==7 || key==6 || key==5 || key==4 || key==3 || key==2 || key==1)){
		client_print(id,print_center,"%L",id,"NOT_PURCHASE_WHEN_DEAD")
		return PLUGIN_CONTINUE
	}

	if(key==p_data[id][P_ITEM2]-1 && key!=ITEM_RING-1){
		client_print(id,print_center,"%L",id,"ALREADY_OWN_THAT_ITEM")
		return PLUGIN_HANDLED
	}
	if(key==ITEM_SCROLL-1 && endround){
		client_print(id,print_center,"%L",id,"NOT_PURCHASE_AFTER_ENDROUND")
		return PLUGIN_HANDLED
	}

	if (get_user_money(id)<itemcost2[key]){
		client_print(id,print_center,"%L",id,"INSUFFICIENT_FUNDS")
		return PLUGIN_HANDLED
	}

	else{
		if (p_data[id][P_ITEM2]==ITEM_AMULET)
			p_data_b[id][PB_SILENT] = false
		if (p_data[id][P_ITEM2]==ITEM_HELM)
			Item_Set_Helm(id,0)
		if (p_data[id][P_ITEM2]==ITEM_CHAMELEON)
			changeskin(id,SKIN_SWITCH)
		if (p_data[id][P_ITEM2]!=ITEM_RING){
			if(task_exists(TASK_ITEM_RINGERATE+id))
				remove_task(TASK_ITEM_RINGERATE+id)
			p_data[id][P_RINGS]=0
		}
		if (p_data[id][P_ITEM2]!=ITEM_GLOVES){
			if(task_exists(TASK_ITEM_GLOVES+id))
				remove_task(TASK_ITEM_GLOVES+id)
		}
		if (p_data[id][P_ITEM2]==ITEM_WAND){
			clone_destroy(id,0)
			clone_destroy(id,1)
		}
		p_data[id][P_ITEM2]=key+1
		if (p_data[id][P_ITEM2]==ITEM_CHAMELEON && is_user_alive(id))
			changeskin(id,SKIN_RESET)
		if (p_data[id][P_ITEM2]==ITEM_HELM)
			Item_Set_Helm(id,1)
		if (p_data[id][P_ITEM2]==ITEM_WAND)
			create_clone(id)
		if (p_data[id][P_ITEM2]==ITEM_AMULET)
			p_data_b[id][PB_SILENT] = true
		if (p_data[id][P_ITEM2]==ITEM_SCROLL && !is_user_alive(id) && !endround)
		{	
			if(get_user_team(id)==TS || get_user_team(id)==CTS){
				new parm[2]
				parm[0]=id
				parm[1]=6
				set_task(0.2,"func_spawn",TASK_ITEM_SCROLL+id,parm,2)
				p_data_b[id][PB_SPAWNEDFROMITEM]=true
				p_data[id][P_ITEM2]=0
				p_data[id][P_ITEM]=0
			}
		}
		if (p_data[id][P_ITEM2]==ITEM_GLOVES){
			if (iCvar[FT_NO_GLOVES_ON_KA]){
			#if MOD == 0
				if(!g_giveHE){
					client_print(id,print_center,"%L",id,"FLAMING_GLOVES_RESTRICTED_ON_THIS_MAP")

					p_data[id][P_ITEM2]=0
					return PLUGIN_HANDLED
				}
				else{
					new parm[2]
					parm[0]=id
					giveheifnothas(parm)
					p_data[id][P_NADETIME]=iCvar[FT_GLOVE_TIMER]
				}
			#endif
			#if MOD == 1
				new parm[2]
				parm[0]=id
				giveheifnothas(parm)
				p_data[id][P_NADETIME]=iCvar[FT_GLOVE_TIMER]
			#endif
			}
			else{
				new parm[2]
				parm[0]=id
				giveheifnothas(parm)
				p_data[id][P_NADETIME]=iCvar[FT_GLOVE_TIMER]
			}
		}
		if (p_data[id][P_ITEM2]==ITEM_RING){
			new parm[2]
			parm[0]=id
			if (p_data[id][P_RINGS]<5){
				++p_data[id][P_RINGS]
				if(!task_exists(TASK_ITEM_RINGERATE+id))
					regenerate(parm)
			}
			else{
				client_print(id,print_center,"%L",id,"NOT_PURCHASE_MORE_THAN_FIVE_RINGS")
				return PLUGIN_HANDLED
			}
		}
		set_user_money(id,get_user_money(id)-itemcost2[key],1)
	}

	emit_sound(id,CHAN_STATIC, SOUND_PICKUPITEM, 1.0, ATTN_NORM, 0, PITCH_NORM)

	WAR3_Display_Level(id,DISPLAYLEVEL_NONE)

	return PLUGIN_HANDLED
}

public regenerate(parm[]){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("regenerate",parm[0])
	#endif

	new id = parm[0]

	if(!is_user_connected(id))
		return PLUGIN_CONTINUE

	new realhealth
	if(p_data[id][P_ITEM2]!=ITEM_RING)
		return PLUGIN_HANDLED
	new bonus = p_data[id][P_RINGS]
	set_hudmessage(0, 100, 0, 0.05, 0.65, 2, 0.02, 10.0, 0.01, 0.1, 2)
	set_task(2.0,"regenerate",TASK_ITEM_RINGERATE+id,parm,2)
	if(get_user_health(id)>1500)
		return PLUGIN_HANDLED
	new temp = bonus
	while(temp!=0){
		bonus = 1
		if (((p_data[id][P_RACE] == 9 && race9Options[2] == 2) || p_data[id][P_RACE] == 2) && p_data[id][P_SKILL2]){		// Devotion Aura Regenerate
			if(p_data[id][P_ITEM]==ITEM_HEALTH){
				if (p_data[id][P_SKILL2]-1==0 && get_user_health(id)<(p_devotion[0]+iCvar[FT_HEALTH_BONUS]))
					set_user_health(id, get_user_health(id)+bonus)
				else if (p_data[id][P_SKILL2]-1==1 && get_user_health(id)<(p_devotion[1]+iCvar[FT_HEALTH_BONUS]))
					set_user_health(id, get_user_health(id)+bonus)
				else if (p_data[id][P_SKILL2]-1==2 && get_user_health(id)<(p_devotion[2]+iCvar[FT_HEALTH_BONUS]))
					set_user_health(id, get_user_health(id)+bonus)
			}
			else{
				if (p_data[id][P_SKILL2]-1==0 && get_user_health(id)<p_devotion[0])
					set_user_health(id, get_user_health(id)+bonus)
				else if (p_data[id][P_SKILL2]-1==1 && get_user_health(id)<p_devotion[1])
					set_user_health(id, get_user_health(id)+bonus)
				else if (p_data[id][P_SKILL2]-1==2 && get_user_health(id)<p_devotion[2])
					set_user_health(id, get_user_health(id)+bonus)
			}
		}
		else if (p_data_b[id][PB_EVADENEXTSHOT]==true){
			if (get_user_health(id)>(100+iCvar[FT_HEALTH_BONUS])){
				realhealth = get_user_health(id)-1024
				if (p_data[id][P_ITEM]==ITEM_HEALTH && realhealth<(100+iCvar[FT_HEALTH_BONUS]))
					set_user_health(id, get_user_health(id)+bonus)
				else if (realhealth<100)
					set_user_health(id, get_user_health(id)+bonus)
			}
		}
		else if (p_data[id][P_ITEM]==ITEM_HEALTH && get_user_health(id)<(100+iCvar[FT_HEALTH_BONUS]))
			set_user_health(id, get_user_health(id)+bonus)
		else if (get_user_health(id)<100)
			set_user_health(id, get_user_health(id)+bonus)
		temp--
	}
	return PLUGIN_CONTINUE

}

public giveheifnothas(parm[2]) { 
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("giveheifnothas",parm[0])
	#endif

	new id = parm[0]

	if(!is_user_connected(id))
		return PLUGIN_CONTINUE

	new wpnList[32] = 0 
	new number = 0
	new foundNade = false 
	get_user_weapons(id,wpnList,number) 
	for (new i = 0;i < number && !foundNade;i++) { 
		#if MOD == 0
			if (wpnList[i] == CSW_HEGRENADE) 
				foundNade = true 
		#endif
		#if MOD == 1
			if (wpnList[i] == DODW_HANDGRENADE || wpnList[i] == DODW_STICKGRENADE) 
				foundNade = true 
		#endif
	}

	if (!foundNade && is_user_alive(id)) 
	{ 
		set_hudmessage(0, 100, 0, 0.05, 0.65, 2, 0.02, 10.0, 0.01, 0.1, 2)
		show_hudmessage(id,"%L",id,"ENJOY_A_GRENADE")
		#if MOD == 0
			give_item(id,"weapon_hegrenade")
		#endif
		#if MOD == 1
			if(get_user_team(id)==ALLIES)
				give_item(id,"weapon_handgrenade")
			else
				give_item(id,"weapon_stickgrenade")
		#endif
	} 

	p_data_b[id][PB_NADEJUSTRECEIVED]=false
	return PLUGIN_CONTINUE 
} 

public WC3_Menu(id){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("WC3_Menu",id)
	#endif

	if (warcraft3==false)
		return PLUGIN_CONTINUE

	if (iCvar[FT_CD]) {
		if (!WAR3_CD_installed(id)){
			client_print(id,print_chat,"%L",id,"CHEATING_DEATH_NOT_INSTALLED",g_MOD)
			return PLUGIN_CONTINUE
		}
	}

	new pos = 0, i, menu_body[512], menu_items[6][32]
	new keys = (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<9)

	format(menu_items[0],31,"%L",id,"SKILLS_MENU")
	format(menu_items[1],31,"%L",id,"RACE_MENU")
	format(menu_items[2],31,"%L",id,"ITEM_MENU")
	format(menu_items[3],31,"%L",id,"INITIATE")
	format(menu_items[4],31,"%L",id,"HELP")
	format(menu_items[5],31,"%L",id,"ADMIN_MENU_TITLE")

	pos += format(menu_body[pos], 511-pos, "%L^n^n",id,"MENU_WAR3_FT_MENU")
	for (i = 0; i<6; i++){
		pos += format(menu_body[pos], 511-pos, "\w%d. %s^n",i+1,menu_items[i])
	}
	pos += format(menu_body[pos], 511-pos, "^n\w0. %L",id,"EXIT_STRING")
	show_menu(id,keys,menu_body,-1)

	return PLUGIN_CONTINUE
}

public do_wc3menu(id,key){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("do_wc3menu",id)
	#endif

	switch (key){
		case 0:	skills_menu(id)
		case 1:	race_menu(id)
		case 2:	item_menu(id)
		case 3:	war3_vote(id,1)
		case 4:	war3_info(id,1)
		case 5:	admin_menu(id)
		default:	return PLUGIN_HANDLED
	}
	
	return PLUGIN_HANDLED
}

skills_menu(id){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("skills_menu",id)
	#endif

	new pos = 0, i, menu_body[512], menu_items[3][32]
	new keys = (1<<0)|(1<<1)|(1<<2)|(1<<8)|(1<<9)


	format(menu_items[0],31,"%L",id,"SELECT_SKILLS")
	format(menu_items[1],31,"%L",id,"SKILLS_INFORMATION")
	format(menu_items[2],31,"%L",id,"RESELECT_SKILLS")

	pos += format(menu_body[pos], 511-pos, "%L^n^n",id,"MENU_SKILLS_OPTIONS")
	for (i = 0; i<3; i++){
		pos += format(menu_body[pos], 511-pos, "\w%d. %s^n",i+1,menu_items[i])
	}
	pos += format(menu_body[pos], 511-pos, "^n^n\w9. %L",id,"BACK_STRING")
	pos += format(menu_body[pos], 511-pos, "^n\w0. %L",id,"EXIT_STRING")
	show_menu(id,keys,menu_body,-1)

	return PLUGIN_CONTINUE
}

public do_skillsmenu(id,key){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("do_skillsmenu",id)
	#endif

	switch (key){
		case 0:	select_skill(id,1)
		case 1:	skills_info(id,1)
		case 2:	resetSkills(id,1)
		case 8: WC3_Menu(id)
		default: return PLUGIN_HANDLED
	}
	return PLUGIN_HANDLED
}

race_menu(id){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("race_menu",id)
	#endif

	new pos = 0, i, menu_body[512], menu_items[4][32]
	new keys = (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<8)|(1<<9)

	format(menu_items[0],31,"%L",id,"CHANGE_RACE")
	format(menu_items[1],31,"%L",id,"SHOW_LEVEL")
	format(menu_items[2],31,"%L",id,"RESET_XP")
	format(menu_items[3],31,"%L",id,"SHOW_PLAYER_SKILLS")

	pos += format(menu_body[pos], 511-pos, "%L^n^n",id,"MENU_RACE_OPTIONS")
	for (i = 0; i<4; i++){
		pos += format(menu_body[pos], 511-pos, "\w%d. %s^n",i+1,menu_items[i])
	}
	pos += format(menu_body[pos], 511-pos, "^n^n\w9. %L",id,"BACK_STRING")
	pos += format(menu_body[pos], 511-pos, "^n\w0. %L",id,"EXIT_STRING")
	show_menu(id,keys,menu_body,-1)

	return PLUGIN_CONTINUE
}

public do_racemenu(id,key){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("do_racemenu",id)
	#endif

	switch (key){
		case 0:	change_race(id,1)
		case 1:	WAR3_Display_Level(id,DISPLAYLEVEL_SHOWRACE)
		case 2:	amx_resetxp(id,1)
		case 3:	player_skills(id)
		case 8: WC3_Menu(id)
		default: return PLUGIN_HANDLED
	}
	return PLUGIN_HANDLED
}

item_menu(id){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("item_menu",id)
	#endif

	new pos = 0, i, menu_body[512], menu_items[4][32]
	new keys = (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<8)|(1<<9)

	format(menu_items[0],31,"%L",id,"SHOPMENU1_OPTION")
	format(menu_items[1],31,"%L",id,"SHOPMENU2_OPTION")
	format(menu_items[2],31,"%L",id,"SHOW_SHOPMENU1_INFO")
	format(menu_items[3],31,"%L",id,"SHOW_SHOPMENU2_INFO")

	pos += format(menu_body[pos], 511-pos, "%L^n^n",id,"MENU_ITEM_OPTIONS")
	for (i = 0; i<4; i++){
		pos += format(menu_body[pos], 511-pos, "\w%d. %s^n",i+1,menu_items[i])
	}
	pos += format(menu_body[pos], 511-pos, "^n^n\w9. %L",id,"BACK_STRING")
	pos += format(menu_body[pos], 511-pos, "^n\w0. %L",id,"EXIT_STRING")
	show_menu(id,keys,menu_body,-1)

	return PLUGIN_CONTINUE
}

public do_itemmenu(id,key){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("do_itemmenu",id)
	#endif

	switch (key){
		case 0:	shopmenu(id)
		case 1:	shopmenu2(id)
		case 2:	items_info(id,1)
		case 3:	items_info2(id,1)
		case 8: WC3_Menu(id)
		default: return PLUGIN_HANDLED
	}
	return PLUGIN_HANDLED
}

// Code taken from plmenu.sma (default AMX file)
new g_menuPosition[33]
new g_menuPlayers[33][32]
new g_menuPlayersNum[33]
new g_menuOption[33]
new g_menuSettings[33]

admin_menu(id){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("admin_menu",id)
	#endif

	if (!(get_user_flags(id)&ADMIN_LEVEL_WC3)) { 
		if(id != 0){
			client_print(id,print_center,"%L",id,"YOU_HAVE_NO_ACCESS",g_MOD)
			return PLUGIN_HANDLED
		}
	}

	new pos = 0, i, menu_body[512], menu_items[3][32]
	new keys = (1<<0)|(1<<1)|(1<<2)|(1<<8)|(1<<9)

	format(menu_items[0],31,"%L",id,"GIVE_IND_XP")
	format(menu_items[1],31,"%L",id,"GIVE_MULT_XP")
	format(menu_items[2],31,"%L",id,"SAVE_ALL_XP")

	pos += format(menu_body[pos], 511-pos, "%L^n^n",id,"MENU_ADMIN_MENU")
	for (i = 0; i<3; i++){
		pos += format(menu_body[pos], 511-pos, "\w%d. %s^n",i+1,menu_items[i])
	}
	pos += format(menu_body[pos], 511-pos, "^n^n\w9. %L",id,"BACK_STRING")
	pos += format(menu_body[pos], 511-pos, "^n\w0. %L",id,"EXIT_STRING")
	show_menu(id,keys,menu_body,-1)

	return PLUGIN_CONTINUE
}

public do_adminmenu(id,key){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("do_adminmenu",id)
	#endif

	switch (key){
		case 0:{
			g_menuOption[id] = 1
			g_menuSettings[id] = 50
			playerxp_menu(id,g_menuPosition[id] = 0)
		}
		case 1:{
			g_menuOption[id] = 1
			g_menuSettings[id] = 50
			teamxp_menu(id)
		}
		case 2: server_cmd("amx_savexp @ALL")
		case 8: WC3_Menu(id)
		default: return PLUGIN_HANDLED
	}
	return PLUGIN_HANDLED
}

playerxp_menu(id,pos){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("playerxp_menu",id)
	#endif

	if (pos < 0){
		admin_menu(id)
		return PLUGIN_CONTINUE
	}

	get_players(g_menuPlayers[id],g_menuPlayersNum[id])
	new menuBody[512]
	new b = 0
	new i
	new name[32], team[4], title[128], more[16], back[16], exitstring[16]
	new start = pos * 7
	if (start >= g_menuPlayersNum[id])
		start = pos = g_menuPosition[id] = 0
	format(title,127,"%L",id,"MENU_GIVE_PLAYERS_XP")
	new len = format(menuBody,511, "%s\R%d/%d^n\w^n",title,pos+1,(g_menuPlayersNum[id] / 7 + ((g_menuPlayersNum[id] % 7) ? 1 : 0 )))
	new end = start + 7
	new keys = (1<<9)|(1<<7)

	if (end > g_menuPlayersNum[id])
		end = g_menuPlayersNum[id]

	for(new a = start; a < end; ++a){
		i = g_menuPlayers[id][a]
		get_user_name(i,name,31)
		get_user_team(i,team,3)
		keys |= (1<<b)
		len += format(menuBody[len],511-len,"\w%d. %s^n\w",++b,name)
	}

	format(title,127,"%L",id,"GIVE")
	len += format(menuBody[len],511-len,"^n8. %s  %d XP^n",title,g_menuSettings[id])

	format(back,15,"%L",id,"BACK_STRING")

	if (end != g_menuPlayersNum[id]){
		format(more,15,"%L",id,"MORE_STRING")
		format(menuBody[len],511-len,"^n9. %s...^n0. %s", more, pos ? back : back)
		keys |= (1<<8)
	}
	else{
		format(exitstring,15,"%L",id,"EXIT_STRING")
		format(menuBody[len],511-len,"^n0. %s", pos ? back : exitstring)
	}


	show_menu(id,keys,menuBody,-1)
	return PLUGIN_CONTINUE

}

public do_playerxpmenu(id,key){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("do_playerxpmenu",id)
	#endif

	switch(key){
		case 7:{
			++g_menuOption[id]
			if (g_menuOption[id]>6){
				g_menuOption[id]=1
			}
			switch(g_menuOption[id]){
				case 1: g_menuSettings[id] = 50
				case 2: g_menuSettings[id] = 100
				case 3: g_menuSettings[id] = 500
				case 4: g_menuSettings[id] = 1000
				case 5: g_menuSettings[id] = 5000
				case 6: g_menuSettings[id] = 10000
			}
			playerxp_menu(id,g_menuPosition[id])
		}
		case 8: playerxp_menu(id,++g_menuPosition[id])
		//case 9: playerxp_menu(id,--g_menuPosition[id])
		case 9: return PLUGIN_HANDLED
		default:{
			new player = g_menuPlayers[id][g_menuPosition[id] * 7 + key]
			client_print(player,print_chat,"%L",id,"THE_ADMIN_JUST_GAVE_YOU_XP",g_MOD,g_menuSettings[id])
			p_data[player][P_XP] =  g_menuSettings[id]

			WAR3_Display_Level(player,DISPLAYLEVEL_SHOWGAINED) 

			playerxp_menu(id,g_menuPosition[id])
		}
	}
	return PLUGIN_HANDLED
}

teamxp_menu(id){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("teamxp_menu",id)
	#endif

	new pos = 0, i, menu_body[512], menu_items[3][32], give[16]
	new keys = (1<<0)|(1<<1)|(1<<2)|(1<<7)|(1<<8)|(1<<9)

	format(menu_items[0],31,"%L",id,"TERRORISTS")
	format(menu_items[1],31,"%L",id,"CT")
	format(menu_items[2],31,"%L",id,"EVERYONE")

	pos += format(menu_body[pos], 511-pos, "%L^n^n",id,"MENU_TEAM_XP")
	for (i = 0; i<3; i++){
		pos += format(menu_body[pos], 511-pos, "\w%d. %s^n",i+1,menu_items[i])
	}
	format(give,15,"%L",id,"GIVE")
	pos += format(menu_body[pos], 511-pos,"^n8. %s  %d XP^n",give,g_menuSettings[id])
	pos += format(menu_body[pos], 511-pos, "^n^n\w9. %L",id,"BACK_STRING")
	pos += format(menu_body[pos], 511-pos, "^n\w0. %L",id,"EXIT_STRING")
	show_menu(id,keys,menu_body,-1)

	return PLUGIN_CONTINUE
}

public do_teamxpmenu(id,key){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("do_teamspmenu",id)
	#endif

	switch(key){
		case 0:{
			server_cmd("amx_givexp @TERRORIST %d",g_menuSettings[id])
			teamxp_menu(id)
		}
		case 1:{
			server_cmd("amx_givexp @CT %d",g_menuSettings[id])
			teamxp_menu(id)
		}
		case 2:{
			server_cmd("amx_givexp @ALL %d",g_menuSettings[id])
			teamxp_menu(id)
		}
		case 7:{
			++g_menuOption[id]
			if (g_menuOption[id]>6){
				g_menuOption[id]=1
			}
			switch(g_menuOption[id]){
				case 1: g_menuSettings[id] = 50
				case 2: g_menuSettings[id] = 100
				case 3: g_menuSettings[id] = 500
				case 4: g_menuSettings[id] = 1000
				case 5: g_menuSettings[id] = 5000
				case 6: g_menuSettings[id] = 10000
			}
			teamxp_menu(id)
		}
		case 8: admin_menu(id)
		case 9: return PLUGIN_HANDLED
		default: return PLUGIN_HANDLED
	}
	return PLUGIN_HANDLED
}


public plugin_precache() {
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("plugin_precache",0)
	#endif

	new mapname[32]
	get_mapname(mapname,31)

	if(equali(mapname,"dod_caen") || equali(mapname,"dod_charlie") || equali(mapname,"dod_escape") 
		|| equali(mapname,"dod_falaise") || equali(mapname,"dod_forest") 
		|| equali(mapname,"dod_kalt") || equali(mapname,"dod_vicenza")){
		g_mapDisabled = true
		log_amx("[%s] War3FT is disabled using map: %s because of the half-life engine precached items limit",g_MOD,mapname)
		server_print("[%s] War3FT is disabled using map: %s because of the half-life engine precached items limit",g_MOD,mapname)
		return PLUGIN_CONTINUE
	}

	g_sFireball = precache_model("sprites/zerogxplode.spr")

	g_sSpriteTexture = precache_model( "sprites/shockwave.spr")
	g_siBeam4 = precache_model("sprites/zbeam4.spr")
	g_sLightning = precache_model("sprites/lgtning.spr")
	g_sFire = precache_model("sprites/explode1.spr") 
	g_sBurning = precache_model("sprites/xfire.spr") 
	precache_model("models/player/alien4/alien4.mdl")  
	
	g_sShadow = precache_model("sprites/animglow01.spr")
	g_sBeetle = precache_model("sprites/agrunt1.spr")
	g_siTrail = precache_model("sprites/smoke.spr")
	g_sSnow = precache_model("sprites/snow.spr") 
	g_sFlare = precache_model( "sprites/blueflare2.spr")

	WAR3_precache()

	if(is_running("czero")){
		precache_model("models/player/spetsnaz/spetsnaz.mdl")
		precache_model("models/player/militia/militia.mdl")
	}

	#if MOD == 0
		g_sSmoke = precache_model("sprites/steam1.spr")

		precache_model("models/player/gign/gign.mdl")
		precache_model("models/player/sas/sas.mdl")
		precache_model("models/player/gsg9/gsg9.mdl")
		precache_model("models/player/urban/urban.mdl")

		precache_model("models/player/arctic/arctic.mdl") 
		precache_model("models/player/leet/leet.mdl") 
		precache_model("models/player/guerilla/guerilla.mdl") 
		precache_model("models/player/terror/terror.mdl") 
	#endif

	#if MOD == 1
		precache_model("models/player/axis-inf/axis-inf.mdl")
		precache_model("models/player/axis-para/axis-para.mdl")
		//precache_model("models/player/brit-inf/brit-inf.mdl")
		precache_model("models/player/us-inf/us-inf.mdl")
		precache_model("models/player/us-para/us-para.mdl")
	#endif

#if MOD != 1
	if (!equali(mapname,"de_inferno_cz")){
		g_spritesEnabled = true

		g_sRace[0] = precache_model("sprites/warcraft3/races/wc3_none_01.spr")
		g_sRace[1] = precache_model("sprites/warcraft3/races/wc3_undead_01.spr")
		g_sRace[2] = precache_model("sprites/warcraft3/races/wc3_human_01.spr")
		g_sRace[3] = precache_model("sprites/warcraft3/races/wc3_orc_01.spr")
		g_sRace[4] = precache_model("sprites/warcraft3/races/wc3_elves_01.spr")
		g_sRace[5] = precache_model("sprites/warcraft3/races/wc3_bloodmage_01.spr")
		g_sRace[6] = precache_model("sprites/warcraft3/races/wc3_shadow_01.spr")
		g_sRace[7] = precache_model("sprites/warcraft3/races/wc3_warden_01.spr")
		g_sRace[8] = precache_model("sprites/warcraft3/races/wc3_cryptlord_01.spr")
		g_sRace[9] = precache_model("sprites/warcraft3/races/wc3_chameleon_01.spr")
	
		g_sLevel[0] = precache_model("sprites/warcraft3/level/a_level_0.spr")
		g_sLevel[1] = precache_model("sprites/warcraft3/level/a_level_1.spr")
		g_sLevel[2] = precache_model("sprites/warcraft3/level/a_level_2.spr")
		g_sLevel[3] = precache_model("sprites/warcraft3/level/a_level_3.spr")
		g_sLevel[4] = precache_model("sprites/warcraft3/level/a_level_4.spr")
		g_sLevel[5] = precache_model("sprites/warcraft3/level/a_level_5.spr")
		g_sLevel[6] = precache_model("sprites/warcraft3/level/a_level_6.spr")
		g_sLevel[7] = precache_model("sprites/warcraft3/level/a_level_7.spr")
		g_sLevel[8] = precache_model("sprites/warcraft3/level/a_level_8.spr")
		g_sLevel[9] = precache_model("sprites/warcraft3/level/a_level_9.spr")
		g_sLevel[10] = precache_model("sprites/warcraft3/level/a_level_10.spr")
	}
#endif

	return PLUGIN_CONTINUE
}

public showRank(id){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("showRank",id)
	#endif

	if(!p_data[id][P_SPECMODE] || !warcraft3 || g_mapDisabled || !iCvar[FT_SPEC_INFO])
		return PLUGIN_CONTINUE

	new a = read_data(2)

	if (!is_user_connected(a))
		return PLUGIN_CONTINUE		// not valid target 

	new name[32]
	get_user_name( a ,name,31) 
	new temp[512]
	new message[1048]

	if (p_data[a][P_XP]<0)
		p_data[a][P_XP]=0

	for (new i=0; i<=10; ++i){
		if (p_data[a][P_XP]>=xplevel[i])
			p_data[a][P_LEVEL]=i
		else
			break
	}

	new short_race_name[SHORT_RACE_NAME_LENGTH]
	shortracename(p_data[a][0],id,short_race_name,SHORT_RACE_NAME_LENGTH_F)

	if (p_data[a][P_LEVEL]==0)
		format(temp,511,"%s   XP: %d/%d",short_race_name,p_data[a][P_XP],xplevel[p_data[a][P_LEVEL]+1])
	else if (p_data[a][P_LEVEL]<10)
		format(temp,511,"%L",id,"LEVEL",short_race_name,p_data[a][P_LEVEL],p_data[a][P_XP],xplevel[p_data[a][P_LEVEL]+1])
	else
		format(temp,511,"%L",id,"LEVEL10",short_race_name,p_data[a][P_LEVEL],xplevel[p_data[a][P_LEVEL]])

	add(message,1047,temp)

	if (p_data[a][P_ITEM]!=0 && (p_data[a][P_ITEM2]!=0 && p_data[a][P_ITEM2]!=ITEM_MOLE)){
		new item_name[ITEM_NAME_LENGTH], item_name2[ITEM_NAME_LENGTH]
		itemname(p_data[a][P_ITEM],id,item_name,ITEM_NAME_LENGTH_F)
		itemname2(p_data[a][P_ITEM2],id,item_name2,ITEM_NAME_LENGTH_F)

		if (p_data[a][P_ITEM2]==ITEM_RING)
			format(temp,511,"%L",id,"SHOWRANK_PLAYERITEM",item_name,item_name2,p_data[a][P_RINGS])
		else
			format(temp,511,"%L",id,"SHOWRANK_PLAYERITEM2",item_name,item_name2)
	}
	else if (p_data[a][P_ITEM]==0 && (p_data[a][P_ITEM2]!=0 && p_data[a][P_ITEM2]!=ITEM_MOLE)){
		new item_name2[ITEM_NAME_LENGTH]
		itemname2(p_data[a][P_ITEM2],id,item_name2,ITEM_NAME_LENGTH_F)

		if (p_data[a][P_ITEM2]==ITEM_RING)
			format(temp,511,"^n%s x%d",item_name2,p_data[a][P_RINGS])
		else
			format(temp,511,"^n%s",item_name2)
	}
	else
		format(temp,511,"")

	add(message,1047,temp)

	new thehealth = get_user_health(a)
	if (thehealth>500)
		thehealth-=1024
	format(temp,511,"%L",id,"CURRENT_HEALTH",thehealth,get_user_armor(a))
	add(message,1047,temp)
	if(iCvar[FT_POSITION]==0)
		set_hudmessage(255,255,255,0.018,0.9,2, 1.5, 12.0, 0.02, 5.0, 1) 
	else
		set_hudmessage(255,255,255,0.65,0.9,2, 1.5, 12.0, 0.02, 5.0, 1) 

	show_hudmessage(id,message) 
	
	return PLUGIN_CONTINUE
}

public setSpecMode(id) {
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("setSpecMode",0)
	#endif

	new arg[12] 
	read_data( 2 , arg , 11 ) 
	p_data[id][P_SPECMODE] = ( arg[10] == '2' ) ? true : false 
}


fire_flamethrower(id){ 
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("fire_flamethrower",id)
	#endif

   emit_sound(id, CHAN_STATIC, SOUND_FLAMESTRIKE, 1.0, ATTN_NORM, 0, PITCH_NORM) 

   new vec[3] 
   new aimvec[3] 
   new velocityvec[3] 
   new length     
   new speed = 10 
   get_user_origin(id,vec) 
   get_user_origin(id,aimvec,2) 
   new dist = get_distance(vec,aimvec) 

   if (p_data[id][P_FLAMECOUNT]==1){
      new parm[2]
      parm[0]=id

      p_data[id][P_ULTIMATEDELAY] = iCvar[FT_ULTIMATE_COOLDOWN]
      _WAR3_Ultimate_Delay(parm)
   }
   new speed1 = 160 
   new speed2 = 350 
   new radius = 105 

   if(dist < 50){ 
      radius = 0 
      speed = 5 
   } 
   else if(dist < 150){ 
      speed1 = speed2 = 1 
      speed = 5 
      radius = 50 
   } 
   else if(dist < 200){ 
      speed1 = speed2 = 1 
      speed = 5 
      radius = 90 
   } 
   else if(dist < 250){ 
      speed1 = speed2 = 90 
      speed = 6 
      radius = 90 
   } 
   else if(dist < 300){ 
      speed1 = speed2 = 140 
      speed = 7 
   } 
   else if(dist < 350){ 
      speed1 = speed2 = 190 
      speed = 7 
   } 
   else if(dist < 400){ 
      speed1 = 150 
      speed2 = 240 
      speed = 8 
   } 
   else if(dist < 450){ 
      speed1 = 150 
      speed2 = 290 
      speed = 8 
   } 
   else if(dist < 500){ 
      speed1 = 180 
      speed2 = 340 
      speed = 9 
   } 

   velocityvec[0]=aimvec[0]-vec[0] 
   velocityvec[1]=aimvec[1]-vec[1] 
   velocityvec[2]=aimvec[2]-vec[2] 
   length=sqrt(velocityvec[0]*velocityvec[0]+velocityvec[1]*velocityvec[1]+velocityvec[2]*velocityvec[2]) 
   velocityvec[0]=velocityvec[0]*speed/length 
   velocityvec[1]=velocityvec[1]*speed/length 
   velocityvec[2]=velocityvec[2]*speed/length 

   new args[8] 
   args[0] = vec[0] 
   args[1] = vec[1] 
   args[2] = vec[2] 
   args[3] = velocityvec[0] 
   args[4] = velocityvec[1] 
   args[5] = velocityvec[2] 
	
   set_task(0.1,"te_spray",TASK_TESPRAY+id,args,8,"a",2) 
   check_burnzone(id,vec,aimvec,speed1,speed2,radius) 

} 

public te_spray(args[]){ 
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("te_spray",0)
	#endif

	new position[3], direction[3]
	position[0] = args[0]
	position[1] = args[1]
	position[2] = args[2]
	direction[0] = args[3]
	direction[1] = args[4]
	direction[2] = args[5]

	Create_TE_SPRAY(position, direction, g_sFire, 8, 70, 100, 5)

	return PLUGIN_CONTINUE 
} 

check_burnzone(id,vec[],aimvec[],speed1,speed2,radius){ 
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("check_burnzone",id)
	#endif

   new maxplayers = get_maxplayers()+1 
   new tbody,tid 
   get_user_aiming(id,tid,tbody,550) 
   if((tid > 0) && (tid < maxplayers)){ 
       burn_victim(tid,id,0) 
   } 
    
   new burnvec1[3],burnvec2[3],length1 

   burnvec1[0]=aimvec[0]-vec[0] 
   burnvec1[1]=aimvec[1]-vec[1] 
   burnvec1[2]=aimvec[2]-vec[2] 

   length1=sqrt(burnvec1[0]*burnvec1[0]+burnvec1[1]*burnvec1[1]+burnvec1[2]*burnvec1[2]) 
   burnvec2[0]=burnvec1[0]*speed2/length1 
   burnvec2[1]=burnvec1[1]*speed2/length1 
   burnvec2[2]=burnvec1[2]*speed2/length1 
   burnvec1[0]=burnvec1[0]*speed1/length1 
   burnvec1[1]=burnvec1[1]*speed1/length1 
   burnvec1[2]=burnvec1[2]*speed1/length1 
   burnvec1[0] += vec[0] 
   burnvec1[1] += vec[1] 
   burnvec1[2] += vec[2] 
   burnvec2[0] += vec[0] 
   burnvec2[1] += vec[1] 
   burnvec2[2] += vec[2] 

   new origin[3] 
   for (new i=1; i<=maxplayers; i++) { 
	 if((is_user_alive(i) == 1) && (i != id) && get_user_team(i)!=get_user_team(id)){ 
		get_user_origin(i,origin) 
		if(get_distance(origin,burnvec1) < radius) 
		   burn_victim(i,id,0) 
		else if(get_distance(origin,burnvec2) < radius) 
		   burn_victim(i,id,0) 
      } 
   } 
   return PLUGIN_CONTINUE       
} 

burn_victim(id,killer,tk){ 
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("burn_victim",id)
	#endif

   if(p_data_b[id][PB_ISBURNING]) 
      return PLUGIN_CONTINUE 
   if (p_data[id][P_ITEM]==ITEM_NECKLACE || p_data_b[id][PB_WARDENBLINK])
      return PLUGIN_CONTINUE
   p_data_b[id][PB_ISBURNING] = true

   new hp,args[4] 
   hp = get_user_health(id) 
   if(hp > 250) 
      hp = 250 
   args[0] = id 
   args[1] = killer 
   args[2] = tk    
   set_task(0.3,"on_fire",TASK_ONFIRE,args,4,"a",hp / 10) 

   return PLUGIN_CONTINUE 
} 

public on_fire(args[]){ 
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("on_fire",args[0])
	#endif

	new rx,ry,rz,forigin[3], position[3]
	new id = args[0]

	if(!is_user_connected(id))
		return PLUGIN_CONTINUE

	new killer = args[1] 
	if(!p_data_b[id][PB_ISBURNING]) 
		return PLUGIN_CONTINUE 
	rx = random_num(-30,30) 
	ry = random_num(-30,30) 
	rz = random_num(-30,30) 
	get_user_origin(id,forigin) 

	position[0] = forigin[0]+rx
	position[1] = forigin[1]+ry
	position[2] = forigin[2]+10+rz

	Create_TE_SPRITE(position, g_sBurning, 30, 200)

	position[0] = forigin[0]+(rx*2)
	position[1] = forigin[1]+(ry*2)
	position[2] = forigin[2]+100+(rz*2)

#if MOD == 0
	Create_TE_Smoke(position, position, g_sSmoke, 60, 15)
#endif

	if(!is_user_alive(id)) 
		return PLUGIN_CONTINUE 

	WAR3_damage(id, killer, 10, CSW_FLAME, 0)

	return PLUGIN_CONTINUE 
}

public healitnow(parm[2]){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("healitnow",parm[0])
	#endif

	new id = parm[0]

	if(!is_user_connected(id))
		return PLUGIN_CONTINUE

	if (!endround && is_user_alive(id) && p_data[id][P_SKILL1] && ((p_data[id][P_RACE] == 9 && race9Options[1] == 6) || p_data[id][P_RACE] == 6)){
		set_task(p_heal[p_data[id][P_SKILL1]-1],"healitnow",TASK_HEALNOW+id,parm,2)
	}
	healingnext(parm)
	return PLUGIN_CONTINUE
}

public healingnext(parm[2]){		// Healing Wave
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("healingnext",parm[0])
	#endif

	new id=parm[0]

	if(!is_user_connected(id))
		return PLUGIN_CONTINUE

	new origin[3]
	get_user_origin(id, origin)
	new players[32]
	new numberofplayers
	new teamname[32]
	get_user_team(id, teamname, 31)
	get_players(players, numberofplayers,"ae",teamname)
	new i
	new targetid = 0
	new distancebetween = 0
	new targetorigin[3]
	new heal = 1
	new closestid = 0
	for (i = 0; i < numberofplayers; ++i){
		targetid=players[i]
		if (get_user_team(id)==get_user_team(targetid) && is_user_alive(targetid)){
			get_user_origin(targetid,targetorigin)
			distancebetween=get_distance(origin,targetorigin)
			if (distancebetween < iCvar[FT_HEALING_RANGE] && !p_data_b[targetid][PB_HEALINGHIT])
				closestid = targetid
		}
	}

	if (closestid){
		healingeffect(id,closestid,heal)
		parm[0]=targetid
		parm[1]=heal
		set_task(0.2,"healingnext",TASK_HEALNEXT+id,parm,2)
	}
	else{
		for (i = 0; i < numberofplayers; ++i){
			targetid=players[i]
			p_data_b[targetid][PB_HEALINGHIT]=false
		}
	}
	return PLUGIN_CONTINUE
}

public healingeffect(id,targetid,heal){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("healingeffect",id)
	#endif

	p_data_b[targetid][PB_HEALINGHIT]=true
	new realhealth
	if (!is_user_alive(targetid))
		return PLUGIN_HANDLED

	if (((p_data[targetid][0] == 9 && race9Options[2] == 2) || p_data[targetid][0] == 2) && p_data[targetid][2]){		// Devotion Aura
		if(p_data[targetid][P_ITEM]==ITEM_HEALTH){
			if (p_data[targetid][2]-1==0 && get_user_health(targetid)<(p_devotion[0]+iCvar[FT_HEALTH_BONUS]))
				set_user_health(targetid, get_user_health(targetid)+heal)
			else if (p_data[targetid][2]-1==1 && get_user_health(targetid)<(p_devotion[1]+iCvar[FT_HEALTH_BONUS]))
				set_user_health(targetid, get_user_health(targetid)+heal)
			else if (p_data[targetid][2]-1==2 && get_user_health(targetid)<(p_devotion[2]+iCvar[FT_HEALTH_BONUS]))
				set_user_health(targetid, get_user_health(targetid)+heal)
		}
		else{
			if (p_data[targetid][2]-1==0 && get_user_health(targetid)<p_devotion[0])
				set_user_health(targetid, get_user_health(targetid)+heal)
			else if (p_data[targetid][2]-1==1 && get_user_health(targetid)<p_devotion[1])
				set_user_health(targetid, get_user_health(targetid)+heal)
			else if (p_data[targetid][2]-1==2 && get_user_health(targetid)<p_devotion[2])
				set_user_health(targetid, get_user_health(targetid)+heal)
		}
	}
	else if (p_data_b[targetid][PB_EVADENEXTSHOT]==true){				// Evasion
		if (get_user_health(targetid)>115){
			realhealth = get_user_health(targetid)-1024
			if (p_data[targetid][P_ITEM]==ITEM_HEALTH && realhealth<(100+iCvar[FT_HEALTH_BONUS]))
				set_user_health(targetid, get_user_health(targetid)+heal)
			else if (realhealth<100)
				set_user_health(targetid, get_user_health(targetid)+heal)
		}
	}
	else if (p_data[targetid][P_ITEM]==ITEM_HEALTH && get_user_health(targetid)<(100+iCvar[FT_HEALTH_BONUS]))	// iCvar[FT_HEALTH_BONUS]
		set_user_health(targetid, get_user_health(targetid)+heal)
	else if (get_user_health(targetid)<100)
		set_user_health(targetid, get_user_health(targetid)+heal)




	new origin[3]
	get_user_origin(targetid,origin)

	if(p_data[targetid][P_ITEM]!=ITEM_CLOAK && (((p_data[targetid][0] == 9 && race9Options[1] != 2) || p_data[targetid][0] != 2) && !p_data[targetid][1])){
		Create_TE_IMPLOSION(origin, 100, 8, 1)
	}
	return PLUGIN_CONTINUE
}

public lightpls(parm[6]){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("lightpls",parm[5])
	#endif

	new id = parm[5]

	if(!is_user_connected(id))
		return PLUGIN_CONTINUE

	if (!is_user_alive(id))
		return PLUGIN_CONTINUE

	new origin[3], damage, start[3], end[3], red, blue
	origin[0]=parm[0]
	origin[1]=parm[1]
	origin[2]=parm[2]

	start[0] = origin[0]
	start[1] = origin[1]
	start[2] = origin[2] + 600
	end[0] = origin[0]
	end[1] = origin[1]
	end[2] = origin[2] - 600

	if(p_data[id][P_SERPENTTEAM]==TS){
		red = 255
		blue = 0
	}
	else{
		red = 0
		blue = 255
	}

	Create_TE_BEAMPOINTS(start, end, g_sLightning, 1, 5, 2, 500, 20, red, 0, blue, 100, 100)


	new players[32]
	new numberofplayers
	get_players(players, numberofplayers)
	new i
	new targetid = 0
	new distancebetween = 0
	new targetorigin[3]
	
	for (i = 0; i < numberofplayers; ++i){
		targetid=players[i]
		if (p_data[id][P_SERPENTTEAM]!=get_user_team(targetid) &&is_user_alive(targetid)){
			get_user_origin(targetid,targetorigin)
			distancebetween=sqrt((origin[1]-targetorigin[1])*(origin[1]-targetorigin[1])+(origin[0]-targetorigin[0])*(origin[0]-targetorigin[0]))
			if ((distancebetween < 85)){
				damage = 10
				WAR3_damage(targetid, id, damage, CSW_SERPENTWARD, 0)

				client_cmd(targetid, "speak ambience/thunder_clap.wav")

				Create_ScreenFade(targetid, (1<<10), (1<<10), (1<<12), red, 0, blue, 255)
			}
		}
	}

	if (!endround)
		set_task(0.5,"lightpls",TASK_LIGHT+id,parm,6)

	return PLUGIN_CONTINUE
}

public ability(id){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("ability",id)
	#endif

	if(iCvar[FT_RACES] < 5)
		return PLUGIN_CONTINUE

	if(is_user_alive(id)){
		if (((p_data[id][P_RACE] == 9 && race9Options[3] == 6) || p_data[id][P_RACE] == 6) && p_data[id][P_SERPENTCOUNT]>0 && !endround){	 //Serpent Ward
			
			if (get_user_team(id)==1)	//CT
				p_data[id][P_SERPENTTEAM]=1
			else				//T
				p_data[id][P_SERPENTTEAM]=2
			new parm[6]
			new origin[3]
			get_user_origin(id,origin)
			parm[0]=origin[0]
			parm[1]=origin[1]
			parm[2]=origin[2]
			parm[5]=id
			lightpls(parm)
			p_data[id][P_SERPENTCOUNT]--
		#if MOD == 0
			set_hudmessage(200, 100, 0, 0.2, 0.3, 0, 1.0, 5.0, 0.1, 0.2, 2)
			show_hudmessage(id,"%L",id,"SERPENT_WARD", p_data[id][P_SERPENTCOUNT])
		#endif
		#if MOD == 1
			new message[128]
			format(message, 127,"%L",id,"SERPENT_WARD", p_data[id][P_SERPENTCOUNT])
			Create_HudText(id, message, 1)
		#endif

		}
	}
	return PLUGIN_HANDLED
}

public checkmap(){					//Prevents war3:FT to give pistols w/knife only maps
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("checkmap",0)
	#endif

	#if MOD ==0
		new mapname[32]
		get_mapname(mapname,31) 
		if (containi(mapname,"ka_")!=-1 || containi(mapname,"scoutzknivez")!=-1){
			g_givePistol=false
			if (iCvar[FT_NO_GLOVES_ON_KA])
				g_giveHE=false
			else
				g_giveHE=true
		}
		else{
			g_giveHE=true
			g_givePistol=true
		}
		if(iCvar[FT_NO_ORCNADES]){
			if (containi(mapname,"ka_")!=-1 || containi(mapname,"jail_riot")!=-1 || containi(mapname,"fy_")!=-1) 
				g_notAllowHE=true
			else
				g_notAllowHE=false
		}
	#endif
	
	return PLUGIN_CONTINUE
}

#if MOD == 0
	public hebuy(id){ 
		#if ADVANCED_DEBUG == 1
			writeDebugInfo("hebuy",id)
		#endif
		if(iCvar[MP_GRENADEPROTECTION]==0)
			return PLUGIN_CONTINUE
		if(!cs_get_user_buyzone(id))
			return PLUGIN_HANDLED
		if (p_data[id][P_HECOUNT]>0){ 
			client_print(id,print_center,"%L",id,"ONLY_ONE_GRENADE_PER_ROUND") 
			return PLUGIN_HANDLED
		} 
		else{
			++p_data[id][P_HECOUNT]
			return PLUGIN_CONTINUE

		}

		return PLUGIN_HANDLED 
	} 
#endif

#if MOD == 0
	public flashbuy(id){
		#if ADVANCED_DEBUG == 1
			writeDebugInfo("flashbuy",id)
		#endif
		if(!cs_get_user_buyzone(id))
			return PLUGIN_HANDLED
		return PLUGIN_CONTINUE
	} 
#endif

public changeskin(id,reset){							// Function changes your skin for ITEM_MOLE and Chameleon
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("changeskin",id)
	#endif
#if MOD == 0
	new num = 0, newSkin[32]
	if (is_running("cstrike"))
		num = random_num(0,3)
	else if (is_running("czero"))
		num = random_num(0,4)

	
	if (reset==SKIN_RESET && (p_data[id][P_SKINCHANGED] == SKIN_HEX || p_data[id][P_SKINCHANGED]==SKIN_SWITCH)){
		cs_reset_user_model(id)
		p_data[id][P_SKINCHANGED]=SKIN_RESET
		console_print(id,"### Skin reset", newSkin)
	}
	else if (reset==SKIN_HEX){ 
		cs_set_user_model(id,"alien4")
		p_data[id][P_SKINCHANGED]=SKIN_HEX
		console_print(id,"### You should look like an alien", newSkin)
	}
	else if (reset==SKIN_SWITCH){
		if (get_user_team(id)==TS)
			add(newSkin,31,CTSkins[num])
		else
			add(newSkin,31,TSkins[num])

		cs_set_user_model(id,newSkin)
		console_print(id,"### You should look like: %s", newSkin)
		p_data[id][P_SKINCHANGED]=SKIN_SWITCH
	}
#endif
	return PLUGIN_CONTINUE
}

public set_variables(){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("set_variables",0)
	#endif

	new divisor

	iCvar[FT_RACE_ICONS				] =	get_cvar_num("FT_race_icons")
	iCvar[FT_LEVEL_ICONS			] =	get_cvar_num("FT_level_icons")
	iCvar[FT_SPEC_INFO				] =	get_cvar_num("FT_spec_info")
	iCvar[FT_MIN_B4_XP				] =	get_cvar_num("FT_min_b4_XP")
	iCvar[FT_BLINK_RADIUS			] =	get_cvar_num("FT_blink_radius")
	iCvar[FT_STEAM					] =	get_cvar_num("FT_steam")
	iCvar[MP_SAVEXP					] =	get_cvar_num("mp_savexp")
	iCvar[FT_SHOW_ICONS				] =	get_cvar_num("FT_show_icons")
	iCvar[FT_HEALTH_BONUS			] =	get_cvar_num("FT_health_bonus")
	iCvar[FT_NO_GLOVES_ON_KA		] = get_cvar_num("FT_no_gloves_on_ka")
	iCvar[FT_GLOVE_ORC_DAMAGE		] = get_cvar_num("FT_glove_orc_damage")
	iCvar[FT_CLAW					] = get_cvar_num("FT_claw")
	iCvar[FT_CLOAK					] = get_cvar_num("FT_cloak")
	iCvar[FT_OBJECTIVES				] = get_cvar_num("FT_objectives")
	iCvar[FT_KILL_OBJECTIVES		] = get_cvar_num("FT_kill_objectives")
	iCvar[FT_ULTIMATE_DELAY			] = get_cvar_num("FT_ultimatedelay") + 1
	iCvar[FT_ULTIMATE_COOLDOWN		] = get_cvar_num("FT_ultimate_cooldown") + 1
	iCvar[FT_RACES					] = get_cvar_num("FT_races")
	iCvar[FT_POSITION				] = get_cvar_num("FT_position")
	iCvar[FT_CONTROL				] = get_cvar_num("FT_control")
	iCvar[FT_START					] = get_cvar_num("FT_start")
	iCvar[FT_STOP					] = get_cvar_num("FT_stop")
	iCvar[FT_MESSAGE				] = get_cvar_num("FT_message")
	iCvar[FT_9RACERANDOM			] = get_cvar_num("FT_9raceRandom")
	iCvar[FT_CD						] = get_cvar_num("FT_CD")
	iCvar[FT_WARN_SUICIDE			] = get_cvar_num("FT_warn_suicide")
	iCvar[FT_BLINKENABLED			] = get_cvar_num("FT_blinkenabled")
	iCvar[SV_ALLOWWAR3VOTE			] = get_cvar_num("sv_allowwar3vote")
	iCvar[SV_MYSQL					] = get_cvar_num("sv_mysql")
	iCvar[SV_MYSQL_SAVE_END_ROUND	] = get_cvar_num("sv_mysql_save_end_round")
	iCvar[FT_SAVEBY					] = get_cvar_num("FT_saveby")
	iCvar[SV_MYSQL_AUTO_PRUNING		] = get_cvar_num("sv_mysql_auto_pruning")
	iCvar[SV_DAYSBEFOREDELETE		] = get_cvar_num("sv_daysbeforedelete")
	iCvar[FT_COMPETITIVE			] = get_cvar_num("FT_competitive")
	iCvar[FT_HEALING_RANGE			] = get_cvar_num("FT_healing_range")
	iCvar[FT_XP_RADIUS				] = get_cvar_num("FT_xp_radius")

	iCvar[MP_WEAPONXPMODIFIER		] = get_cvar_num("mp_weaponxpmodifier")
	iCvar[FT_BLINK_PROTECTION		] = get_cvar_num("FT_blink_protection")

	fCvar[FT_BOT_BUY_ITEM			] = get_cvar_float("FT_bot_buy_item")
	fCvar[FT_FROST_SPEED			] = get_cvar_float("FT_frost_speed")
	fCvar[FT_MASK_OF_DEATH			] = get_cvar_float("FT_mask_of_death")
	fCvar[XPMULTIPLIER				] = get_cvar_float("mp_xpmultiplier")
	fCvar[AMX_VOTE_ANSWERS			] = get_cvar_float("amx_vote_answers")
	fCvar[AMX_VOTEWAR3_RATIO		] = get_cvar_float("amx_votewar3_ratio")

	if(iCvar[MP_SAVEXP])
		divisor = 5
	else
		divisor = 1

	iCvar[XPBONUS					] = get_cvar_num("FT_xpbonus") / divisor

#if MOD == 0
	server_cmd("amx_statscfg off PlayerName")

	iCvar[FT_ITEMS_IN_HUD			] = get_cvar_num("FT_items_in_hud")
	iCvar[FT_NO_ORCNADES			] = get_cvar_num("FT_no_orcnades")
	iCvar[FT_ROUND_WIN_XP			] = get_cvar_num("FT_round_win_XP") / divisor
	iCvar[FT_BOMBPLANTERXP			] = get_cvar_num("FT_bombplanterxp") / divisor
	iCvar[FT_DEFUSEXP				] = get_cvar_num("FT_defusexp") / divisor
	iCvar[FT_HOSTAGEXP				] = get_cvar_num("FT_hostagexp") / divisor
	iCvar[FT_KILLRESCUEMANXP		] = get_cvar_num("FT_killrescuemanxp") / divisor
	iCvar[FT_KILL_BOMB_CARRIER_BONUS] = get_cvar_num("FT_kill_bomb_carrier_bonus") / divisor
	iCvar[FT_HEADSHOT_BONUS			] = (get_cvar_num("FT_headshot_bonus") / divisor) + 2
	iCvar[FT_DEFUSER_KILL_BONUS		] = get_cvar_num("FT_defuser_kill_bonus") / divisor
	iCvar[FT_VIP_ESCAPE_BONUS		] = get_cvar_num("FT_VIP_escape_bonus") / divisor
	iCvar[FT_VIP_KILL_BONUS			] = get_cvar_num("FT_VIP_kill_bonus") / divisor
	iCvar[MP_GRENADEPROTECTION		] = get_cvar_num("mp_grenadeprotection")

	fCvar[FT_BOOTSPEED				] = get_cvar_float("FT_bootspeed")
#endif
#if MOD == 1
	iCvar[DOD_STARTMONEY			] = get_cvar_num("DOD_startmoney")

	fCvar[DOD_BOOTSPEED				] = get_cvar_float("DOD_bootspeed")
#endif


	// Set the version of war3 that is running (war3ft or classic war3?)
	if(iCvar[FT_RACES] < 5)
		g_MOD = "WAR3"
	else
		g_MOD = "WAR3FT"
	
	return PLUGIN_CONTINUE
}

public clear_all_icons(id){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("clear_all_icons",id)
	#endif
	#if MOD == 0
		new string[8][32] = {"dmg_rad","item_longjump","dmg_shock","item_healthkit","dmg_heat","suit_full","cross","dmg_gas"}
		for(new i=0;i<8;i++){
			Create_StatusIcon(id, ICON_HIDE, string[i], 0, 0, 0)
		}
	#endif
	return PLUGIN_CONTINUE
}

public icon_controller(id, value){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("icon_controller",id)
	#endif

	if (!iCvar[FT_SHOW_ICONS])
		return PLUGIN_HANDLED
	if(!p_data[id][P_ULTIMATE])
		return PLUGIN_HANDLED
	if (g_ultimateDelay > 0.0)
		return PLUGIN_HANDLED
	if(p_data_b[id][PB_ULTIMATEUSED] && value!=ICON_HIDE)
		return PLUGIN_HANDLED

#if MOD == 0
	new string[32], r, g, b, switchValue
	if(p_data[id][P_RACE] == 9)
		switchValue = race9Options[4]
	else
		switchValue = p_data[id][P_RACE]

	switch(switchValue){
		case 1:format(string,31,"dmg_rad"),			r=255,	g=0,	b=0			// Undead
		case 2:format(string,31,"item_longjump"),	r=0,	g=120,	b=120		// Human
		case 3:format(string,31,"dmg_shock"),		r=255,	g=255,	b=255		// Orc
		case 4:format(string,31,"item_healthkit"),	r=0,	g=0,	b=255		// Night Elf
		case 5:format(string,31,"dmg_heat"),		r=255,	g=0,	b=0			// Blood Mage
		case 6:format(string,31,"suit_full"),		r=0,	g=200,	b=200		// Shadow Hunter
		case 7:format(string,31,"cross"),			r=255,	g=0,	b=0			// Warden
		case 8:format(string,31,"dmg_gas"),			r=0,	g=255,	b=0			// Crypt Lord
	}

	if(!is_user_alive(id))			// If the user is dead then hide the icon
		value = ICON_HIDE

	if(value==ICON_FLASH){
		if(((p_data[id][P_RACE] == 9 && race9Options[4] == 1) || p_data[id][P_RACE] == 1))
			r=255,g=255,b=255
	}

	Create_StatusIcon(id, value, string, r, g, b)
#endif
	return PLUGIN_CONTINUE
}

public amx_savexp(id, level, cid){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("amx_savexp",id)
	#endif

	if (!(get_user_flags(id)&ADMIN_LEVEL_WC3)) { 
		if(id != 0){
			client_print(id,print_console,"%L",id,"YOU_HAVE_NO_ACCESS", g_MOD)
			return PLUGIN_HANDLED
		}
	}
	new arg[32], xp[10] 
	read_argv(1,arg,31) 
	read_argv(2,xp,9) 
	if(equali(arg,"@ALL")){
		new players[32], inum
		get_players(players,inum) 
		for(new a=0;a<inum;++a){
			write_xp_to_file(players[a])
		} 
		return PLUGIN_HANDLED
	}
	if (arg[0]=='@'){ 
		new players[32], inum
		get_players(players,inum,"e",arg[1]) 
		if (inum==0){ 
			console_print(id,"%L",id,"NO_CLIENTS_IN_TEAM") 
			return PLUGIN_HANDLED 
		} 
		for(new a=0;a<inum;++a){
			write_xp_to_file(players[a])
		} 
	}
	else { 
		new player = cmd_target2(id,arg) 
		if (!player) return PLUGIN_HANDLED 
		write_xp_to_file(player)
	} 
	return PLUGIN_HANDLED 
} 

public amx_resetxp(id,saychat){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("amx_resetxp",id)
	#endif

	p_data[id][P_LEVEL]=0
	p_data[id][P_XP]=0
	p_data[id][P_SKILL1]=0
	p_data[id][P_SKILL2]=0
	p_data[id][P_SKILL3]=0
	p_data[id][P_ULTIMATE]=0
	WAR3_Display_Level(id,DISPLAYLEVEL_NONE)
	write_xp_to_file(id)
	if(saychat==1)
		client_print(id,print_chat,"%L",id,"YOUR_XP_HAS_BEEN_RESET",g_MOD)
	else
		console_print(id,"%L",id,"YOUR_XP_HAS_BEEN_RESET",g_MOD)
}

public amx_givexp(id, level, cid){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("amx_givexp",id)
	#endif

	if (!(get_user_flags(id)&ADMIN_LEVEL_WC3)) {
		if(id != 0){
			client_print(id,print_console,"%L",id,"YOU_HAVE_NO_ACCESS", g_MOD)
			return PLUGIN_HANDLED
		}
	}
	new arg[32], xp[10]
	read_argv(1,arg,31) 
	read_argv(2,xp,9)
	if(equali(arg,"@ALL")){
		new players[32], inum
		get_players(players,inum)
		for(new a=0;a<inum;++a){
			client_print(players[a],print_chat,"%L",id,"THE_ADMIN_GAVE_YOU_EXPERICENE",g_MOD, str_to_num(xp))
			p_data[players[a]][P_XP] += str_to_num(xp)
			WAR3_Display_Level(players[a],DISPLAYLEVEL_NONE)
		}
		return PLUGIN_HANDLED
	}
	if (arg[0]=='@'){ 
		new players[32], inum
		get_players(players,inum,"e",arg[1]) 
		if (inum==0){ 
			console_print(id,"%L",id,"NO_CLIENTS_IN_TEAM") 
			return PLUGIN_HANDLED 
			
		} 
		for(new a=0;a<inum;++a){
			client_print(players[a],print_chat,"%L",id,"THE_ADMIN_GAVE_YOU_EXPERICENE",g_MOD, str_to_num(xp))
			p_data[players[a]][P_XP] += str_to_num(xp)
			WAR3_Display_Level(players[a],DISPLAYLEVEL_NONE)
		}
	}
	else { 
		new player = cmd_target2(id,arg) 
		if (!player) return PLUGIN_HANDLED 
		client_print(player,print_chat,"%L",id,"THE_ADMIN_GAVE_YOU_EXPERICENE",g_MOD, str_to_num(xp))
		p_data[player][P_XP] += str_to_num(xp)
		WAR3_Display_Level(player,DISPLAYLEVEL_NONE)
	}
	return PLUGIN_HANDLED 
} 

public amx_takexp(){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("amx_takexp",0)
	#endif

	new arg[32], arg2[32]
	read_argv(1,arg,31)
	read_argv(2,arg2,31)
	new id = str_to_num(arg)
	p_data[id][P_XP]-=str_to_num(arg2)
	WAR3_Display_Level(id,DISPLAYLEVEL_NONE)
	return PLUGIN_HANDLED
}

public calllocustfunction(id){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("calllocustfunction",id)
	#endif


	new parm[11]
	parm[7]=id
	new players[32], numberofplayers, i, player, possibility[33], count = 0
	get_players(players, numberofplayers)
	for (i = 0; i < numberofplayers; ++i){
		player=players[i]
		if(get_user_team(player)!=get_user_team(id) && is_user_alive(player) && !p_data_b[player][PB_WARDENBLINK] && p_data[player][P_ITEM]!=ITEM_NECKLACE){
			possibility[count]=player
			count++
		}
	}
	if(count==0){
		set_hudmessage(178, 14, 41, -1.0, 0.3, 0, 1.0, 5.0, 0.1, 0.2, 5)
		show_hudmessage(id,"%L",id,"NO_VALID_TARGETS_FOUND")
		return PLUGIN_CONTINUE
	}

	while(parm[6]==0)								// Prevents target from being the server
		parm[6]=possibility[random_num(0,count)]

	new origin[3], origin2[3]
	get_user_origin(id,origin)
	get_user_origin(parm[6],origin2)
	parm[0]=origin[0]
	parm[1]=origin[1]
	parm[2]=origin[2]

	icon_controller(id,ICON_FLASH)

	p_data_b[id][PB_ULTIMATEUSED]=true

	drawfunnels(parm)
	return PLUGIN_CONTINUE
}

public drawfunnels(parm[]){
	new MULTIPLIER = 150 // the lower the number the faster it reaches the target
	new id = parm[6]
	new caster = parm[7]

	if(p_data[id][P_ITEM]==ITEM_NECKLACE || p_data_b[id][PB_WARDENBLINK] || !is_user_alive(id) || !is_user_connected(id)){
		p_data_b[caster][PB_ULTIMATEUSED]=false
		icon_controller(caster,ICON_SHOW)	
		return PLUGIN_HANDLED
	}

	new origin[3], funnel[3], name[32], name2[32]
	get_user_name(id,name,31)
	get_user_name(caster,name2,31)
	get_user_origin(id,origin)

	funnel[0]=parm[0]			// Origin of the funnel
	funnel[1]=parm[1]
	funnel[2]=parm[2]
	
	Create_TE_LARGEFUNNEL(funnel, g_sSnow, 0)
	
	new xdist = diff(origin[0],funnel[0])
	new ydist = diff(origin[1],funnel[1])
	new zdist = diff(origin[2],funnel[2])	

	if(diff(origin[0],(funnel[0]-MULTIPLIER))<xdist)
		parm[0]=funnel[0]-MULTIPLIER
	else if(diff(origin[0],(funnel[0]+MULTIPLIER))<xdist)
		parm[0]=funnel[0]+MULTIPLIER
	else
		parm[0]=origin[0]

	if(diff(origin[1],(funnel[1]-MULTIPLIER))<ydist)
		parm[1]=funnel[1]-MULTIPLIER
	else if(diff(origin[1],(funnel[1]+MULTIPLIER))<ydist)
		parm[1]=funnel[1]+MULTIPLIER
	else
		parm[1]=origin[1]

	if(diff(origin[2],(funnel[2]-MULTIPLIER))<zdist)
		parm[2]=funnel[2]-MULTIPLIER
	else if(diff(origin[2],(funnel[2]+MULTIPLIER))<zdist)
		parm[2]=funnel[2]+MULTIPLIER
	else
		parm[2]=origin[2]

	if(!endround){
		if(!(xdist<50 && ydist<50 && zdist<50)){
			set_task(0.1,"drawfunnels",caster+TASK_FUNNELS,parm,11)
		}
		else{
			WAR3_damage(id, caster, 35, CSW_LOCUSTS, 0)

			emit_sound(id,CHAN_STATIC, SOUND_LOCUSTSWARM, 1.0, ATTN_NORM, 0, PITCH_NORM)

			icon_controller(caster,ICON_HIDE)

			new cooldownparm[2]
			cooldownparm[0]=caster
			
			p_data[caster][P_ULTIMATEDELAY] = iCvar[FT_ULTIMATE_COOLDOWN]
			_WAR3_Ultimate_Delay(cooldownparm)
		}
	}
	return PLUGIN_HANDLED
}

public amx_givemole(id, level, cid){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("amx_givemole",id)
	#endif

	if (!(get_user_flags(id)&ADMIN_LEVEL_A)) { 
		if(id != 0){
			client_print(id,print_console,"%L",id,"YOU_HAVE_NO_ACCESS", g_MOD)
			return PLUGIN_HANDLED
		}
	}
	new arg[32] 
	read_argv(1,arg,31)  
	if(equali(arg,"@ALL")){
		new players[32], inum
		get_players(players,inum) 
		for(new a=0;a<inum;++a){
			p_data[players[a]][P_ITEM2]=ITEM_MOLE
			WAR3_Display_Level(id,DISPLAYLEVEL_NONE)
		} 
		return PLUGIN_HANDLED
	}
	else if (arg[0]=='@'){ 
		new players[32], inum
		get_players(players,inum,"e",arg[1]) 
		if (inum==0){ 
			console_print(id,"%L",id,"NO_CLIENTS_IN_TEAM") 
			return PLUGIN_HANDLED 
		} 
		for(new a=0;a<inum;++a){
			p_data[players[a]][P_ITEM2]=ITEM_MOLE
			WAR3_Display_Level(id,DISPLAYLEVEL_NONE)
		} 
	}
	else { 
		new player = cmd_target2(id,arg) 
		if (!player) return PLUGIN_HANDLED 
		p_data[player][P_ITEM2]=ITEM_MOLE
		WAR3_Display_Level(player,DISPLAYLEVEL_NONE)
	} 

	return PLUGIN_HANDLED 
}

public changeXP(){ 
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("changeXP",0)
	#endif

	new arg1[4]
	new arg2[8]
	read_argv(1,arg1,3)
	read_argv(2,arg2,7)
		
	new id=str_to_num(arg1)
	new xp=str_to_num(arg2)

	if((p_data[id][P_XP] + xp)< 0)
		p_data[id][P_XP] = 0
	else
		p_data[id][P_XP] += xp
	
	WAR3_Display_Level(id, DISPLAYLEVEL_NONE)
}

//amx_wc3 command
public amx_wc3_launch(id, level, cid){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("amx_wc3_launch",id)
	#endif

	if (!(get_user_flags(id)&ADMIN_LEVEL_WC3)) { 
		if(id != 0){
			client_print(id,print_console,"%L",id,"YOU_HAVE_NO_ACCESS", g_MOD)
			return PLUGIN_HANDLED
		}
	}
	new cmds[32]
	read_argv(1,cmds,31)
	set_hudmessage(200, 100, 0, -1.0, 0.3, 2, 1.5, 10.0, 0.02, 5.0,15)
	if (equal(cmds, "on" ))
	{
		set_cvar_num("FT_control",0)
		set_cvar_num("sv_warcraft3",1)
		show_hudmessage(0,"%L",id,"IS_ACTIVATED_NOW",WC3NAME,WC3VERSION)
		return PLUGIN_HANDLED
	}
	else if (equal(cmds, "off" ))
	{
		set_cvar_num("FT_control",0)
		set_cvar_num("sv_warcraft3",0)
		show_hudmessage(0,"%L",id,"IS_NO_LONGER_ACTIVE",WC3NAME,WC3VERSION)
		return PLUGIN_HANDLED
	}
	else if (equal(cmds, "auto" ))
	{
		set_cvar_num("FT_control",1)
		show_hudmessage(0,"%L",id,"IS_IN_AUTOMATIC_g_MODE",WC3NAME,WC3VERSION)
		return PLUGIN_HANDLED
	}
	else
	{
		client_print(id,print_console,"%L",id,"USAGE_STRING", g_MOD)
		return PLUGIN_HANDLED
	}
	return PLUGIN_HANDLED
}

public FT_controller(){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("FT_controller",0)
	#endif

	FT_control = iCvar[FT_CONTROL]
	FT_start = iCvar[FT_START]
	FT_stop = iCvar[FT_STOP]
	FT_message = iCvar[FT_MESSAGE]

	new stime[4],sminute[4]
	get_time("%M",sminute,3)
	get_time("%H",stime,3)
	new minutes = str_to_num(sminute)
	new hours  = str_to_num(stime)
	new nextmap[32]
	get_cvar_string("amx_nextmap",nextmap,31)
	new timeleft = get_timeleft()
	set_hudmessage(50, 50, 200, 0.13, 0.01, 2, 1.5, 12.0, 0.02, 5.0,15)
	new bool:okidoki = false
	new message[128]
	if (FT_control){
		if(FT_start > FT_stop){
			if (((hours >= FT_start) && (hours > FT_stop)) || ((hours < FT_start) && (hours < FT_stop)))
				okidoki = true
		}
		if (FT_stop > FT_start){
			if ((hours >= FT_start) && (hours < FT_stop))
				okidoki = true
		}	
		if (FT_start == FT_stop)
			okidoki = true
		if(okidoki){
			set_cvar_num("sv_warcraft3",1)
			if (FT_start == FT_stop)
				format(message,127,"")
			else{			
				format(message,127,"%L",LANG_PLAYER,"BETWEEN",FT_start,FT_stop)
			}
		}		
		else{
			set_cvar_num("sv_warcraft3",0)
			format(message,127,"de %dh a %dh",FT_stop,FT_start)
		}
		if (!get_cvar_num("sv_warcraft3") && FT_message){
			show_hudmessage(0,"%L",LANG_PLAYER,"INACTIVE",WC3NAME,WC3VERSION,message,hours,minutes,timeleft / 60, timeleft % 60,nextmap)
		}
		if (get_cvar_num("sv_warcraft3") && FT_message){
			show_hudmessage(0,"%L",LANG_PLAYER,"ACTIVE",WC3NAME,WC3VERSION,message,hours,minutes,timeleft / 60, timeleft % 60,nextmap)
		}
		set_hudmessage(200, 100, 0, -1.0, 0.3, 0, 1.0, 10.0, 0.1, 0.2, 17)
		if ((g_lastAnnounce != minutes) && (hours == (FT_start - 1)) && ((minutes == 30) || (minutes == 45)|| (minutes == 55))){
			g_lastAnnounce = minutes
			show_hudmessage(0,"%L",LANG_PLAYER,"IS_ACTIVATED",WC3NAME,60 - minutes)			
		}
		if ((g_lastAnnounce != minutes) && (hours == (FT_stop - 1)) && ((minutes == 30) || (minutes == 45) || (minutes == 55))){
			g_lastAnnounce = minutes
			show_hudmessage(0,"%L",LANG_PLAYER,"WILL_BE_DEACTIVATED_IN",WC3NAME,60 - minutes)
		}
	}
	else
	{
		if (warcraft3==false && FT_message)	{	
			show_hudmessage(0,"%L",LANG_PLAYER,"INACTIVE_ELSE",WC3NAME,WC3VERSION,hours,minutes,timeleft / 60, timeleft % 60,nextmap)	
		}
		if (warcraft3==true && FT_message){
			show_hudmessage(0,"%L",LANG_PLAYER,"ACTIVE_ELSE",WC3NAME,WC3VERSION,hours,minutes,timeleft / 60, timeleft % 60,nextmap)
		}
	}		
	return PLUGIN_CONTINUE
}

public create_clone(id){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("create_clone",id)
	#endif

	if(clone[id][0] || clone[id][1])
		return PLUGIN_CONTINUE 

	new num = random_num(1,2)

	new originplayer[3], originlook[3]
	new distance[2], i
//	new unitsinfront = 80
	new team = get_user_team(id)
	new Float:aimvec[3]    

	new Float:MinBox[3]
	new Float:MaxBox[3]
	MinBox[0]=-20.0
	MinBox[1]=-20.0
	MinBox[2]=-40.0
	MaxBox[0]=20.0
	MaxBox[1]=20.0
	MaxBox[2]=40.0

	new Float:tmpVec[3]

	tmpVec[0]=40.0
	tmpVec[1]=40.0
	tmpVec[2]=80.0

	for(i = 0; i<num;i++){

		get_user_origin(id, originplayer)
		get_user_origin(id, originlook, 2)		// Where player is looking

		distance[0] = originlook[0]-originplayer[0] 
		distance[1] = originlook[1]-originplayer[1]

/*		if(i==0){
			aimvec[0]=float(originplayer[0]+(unitsinfront*distance[0])/sqrt(distance[0]*distance[0]+distance[1]*distance[1]))
			aimvec[1]=float(originplayer[1]+(unitsinfront*distance[1])/sqrt(distance[0]*distance[0]+distance[1]*distance[1]))
			aimvec[2]=float(originplayer[2])+5
		}
		else if(i==1){
			aimvec[0]=float(originplayer[0]-(unitsinfront*distance[0])/sqrt(distance[0]*distance[0]+distance[1]*distance[1]))
			aimvec[1]=float(originplayer[1]-(unitsinfront*distance[1])/sqrt(distance[0]*distance[0]+distance[1]*distance[1]))
			aimvec[2]=float(originplayer[2])+5
		}*/
		if(i==0){
			aimvec[0]=float(originplayer[0]-100)
			aimvec[1]=float(originplayer[1]-100)
			aimvec[2]=float(originplayer[2])+5
		}
		else if(i==1){
			aimvec[0]=float(originplayer[0]+100)
			aimvec[1]=float(originplayer[1]+100)
			aimvec[2]=float(originplayer[2])+5
		}

		clone[id][i] = create_entity("info_target")

		new rnum = 0, model[101]
		#if MOD == 0
			if(is_running("czero")){
				rnum = random_num(0,4)
			}
			else if (is_running("cstrike")){
				rnum = random_num(0,3)
			}
		#endif

		#if MOD == 1
			rnum = random_num(0,1)
		#endif

		#if MOD == 0
			if(team == 1){
				format(model,100,"models/player/%s/%s.mdl",TSkins[rnum],TSkins[rnum])
				entity_set_model(clone[id][i], model)
			}
			else if(team == 2){
				format(model,100,"models/player/%s/%s.mdl",CTSkins[rnum],CTSkins[rnum])
				entity_set_model(clone[id][i], model)
			}
		#endif

		#if MOD == 1
			if(team == ALLIES){
				format(model,100,"models/player/%s/%s.mdl",AlliedSkins[rnum],AlliedSkins[rnum])
				entity_set_model(clone[id][i], model)
			}
			else if(team == AXIS){
				format(model,100,"models/player/%s/%s.mdl",AxisSkins[rnum],AxisSkins[rnum])
				entity_set_model(clone[id][i], model)
			}


		#endif
		entity_set_origin(clone[id][i], aimvec)

		entity_set_vector(clone[id][i],EV_VEC_mins, MinBox)
		entity_set_vector(clone[id][i],EV_VEC_maxs, MaxBox)

		entity_set_vector(clone[id][i],EV_VEC_size,tmpVec)
		entity_set_float(clone[id][i],EV_FL_health,1000.0)
		entity_set_float(clone[id][i],EV_FL_takedamage, 1.0)

		entity_set_int(clone[id][i], EV_INT_solid, 2)
		entity_set_int(clone[id][i], EV_INT_movetype, 11)
		entity_set_byte(clone[id][i], EV_BYTE_controller1, 200)
		new string[32]
		format(string,31,"clone-%d-%d",id,i)
		entity_set_string(clone[id][i], EV_SZ_classname, string)

		new Float:fNewVelocity[3] 
		new Float:newAngle[3]

		VelocityByAim(id, 390, fNewVelocity)
		fNewVelocity[2] = 0.0
		vector_to_angle(fNewVelocity, newAngle)

		entity_set_vector(clone[id][i], EV_VEC_angles, newAngle)
		entity_set_vector(clone[id][i], EV_VEC_velocity, fNewVelocity)

	}
	return PLUGIN_HANDLED
}

public server_frame(){
	#if ADVANCED_DEBUG == 1
		//writeDebugInfo("server_frame",0)
	#endif

	new id,i
	new Float:vel[3]
	new Float:new_frame = get_gametime()
	new Float:newAngle[3]
	new Float:framerate=30.0
	new Float:speed
	if((new_frame - last_frame) < ( 1.0 / framerate))
		return PLUGIN_CONTINUE

	last_frame = new_frame

	for(id=0;id<33;id++){
		for(i=0;i<2;i++){
			if(clone[id][i]){
				new string[32]
				format(string,31,"clone-%d-%d",id,i)
				if(find_ent_by_class(-1,string)>0){
					if(entity_get_float(clone[id][i],EV_FL_health)<900){
						// What happens when they die?
						clone_destroy(id,i)
						return PLUGIN_CONTINUE
					}
					clone_check_dist(id,i)
					drop_to_floor(clone[id][i])
				}
				//Select sequence depending from speed
				entity_get_vector(clone[id][i], EV_VEC_velocity, vel)
				if( vel[0] != 0.0 && vel[1] != 0.0){
					vel[2] = 0.0
					vector_to_angle(vel, newAngle)
					entity_set_vector(clone[id][i], EV_VEC_angles, newAngle)
				}


				vel[2] = 0.0
				speed = vector_length(vel)

				if( speed >= 0 && speed <= 5 && clone_seq[id][i] != 1){				// idle sequence
					clone_seq[id][i] = 1
					entity_set_int(clone[id][i], EV_INT_sequence, 1)
					clone_fstep[id][i] = 5.0
					clone_frame[id][i] = 0.0
				}
				else if( speed >= 6 && speed <= 100 && clone_seq[id][i] != 1 ){		// walk sequence
					clone_seq[id][i] = 1
					entity_set_int(clone[id][i], EV_INT_sequence, 1)
					clone_fstep[id][i] = 8.0
					clone_frame[id][i] = 0.0
				}
				else if( speed >= 101 && clone_seq[id][i] != 4){					// run sequence
					clone_seq[id][i] = 4
					entity_set_int(clone[id][i], EV_INT_sequence, 4)
					clone_fstep[id][i] = 18.0
					clone_frame[id][i] = 0.0
				}

				clone_frame[id][i] += clone_fstep[id][i] 

				if( clone_frame[id][i] >= 254.0 )
				clone_frame[id][i] = 0.0;

				entity_set_float(clone[id][i], EV_FL_frame, clone_frame[id][i])        
			}
		}
	}
	return PLUGIN_CONTINUE
}


public clone_check_dist(id,i){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("clone_check_dist",id)
	#endif

	if(!clone[id][i])
		return PLUGIN_CONTINUE

	new originplayer[3], originlook[3]
	new Float:origincloan[3]
	new Float:playerorigin[3]

	get_user_origin(id, originplayer)
	playerorigin[0] = float(originplayer[0])
	playerorigin[1] = float(originplayer[1])
	playerorigin[2] = float(originplayer[2])
	entity_get_vector(clone[id][i], EV_VEC_origin, origincloan)

	if(vector_distance(playerorigin,origincloan)>1000.0){			// Poor clone got lost, lets put him back by his master... shall we?
		new distance[2]
		new Float:aimvec[3]
		get_user_origin(id, originlook, 2)

		distance[0] = originlook[0]-originplayer[0] 
		distance[1] = originlook[1]-originplayer[1]

		if(i==0){
			aimvec[0]=float(originplayer[0]-100)
			aimvec[1]=float(originplayer[1]-100)
			aimvec[2]=float(originplayer[2])+5
		}
		else if(i==1){
			aimvec[0]=float(originplayer[0]+100)
			aimvec[1]=float(originplayer[1]+100)
			aimvec[2]=float(originplayer[2])+5
		}

		entity_set_origin(clone[id][i], aimvec)
	}

	return PLUGIN_CONTINUE
}

public clone_destroy(id,i){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("clone_destroy",id)
	#endif

	new string[16], string2[16], string3[16]
	format(string,15,"clone-%d-%d",id,i)
	format(string2,15,"clone-%d-0",id)
	format(string3,15,"clone-%d-1",id)

	if(find_ent_by_class(-1,string)>0){
		new Float:origincloan[3], position[3], j, count = 90
		entity_get_vector(clone[id][i], EV_VEC_origin, origincloan)
		position[XPOS] = floatround(origincloan[0])
		position[YPOS] = floatround(origincloan[1])
		position[ZPOS] = floatround(origincloan[2])
		
		for(j=0;j<5;j++){
			Create_TE_IMPLOSION(position, 300, count, 30)
			position[ZPOS] -= 15
			count-=15
		}

		remove_entity(clone[id][i])
		clone[id][i]=0
	}

	if(!(find_ent_by_class(-1,string2)>0 || find_ent_by_class(-1,string3)>0)){
		if(p_data[id][P_ITEM2]==ITEM_WAND){
			p_data[id][P_ITEM2]=0
			WAR3_Display_Level(id,DISPLAYLEVEL_NONE)
		}
	}
}

public clone_think(){
	#if ADVANCED_DEBUG == 1
	//	writeDebugInfo("clone_think",0)
	#endif

	new aimvec[3]
	new origin[3]
	new Float:temp[3] = {0.0,0.0,0.0}
	new avgFactor = 8
	new mVelo[3]
	new iNewVelocity[3]
	new speed = 300   
	new length, velocityvec[3]   
	new id, i

	for(id=0; id<32; id++){
		for(i=0;i<2;i++){
			new string[32]
			format(string,31,"clone-%d-%d",id,i)

			if(clone[id][i] && find_ent_by_class(-1,string)>0){
				get_user_origin(id,aimvec)
				entity_get_vector(clone[id][i], EV_VEC_origin, temp)
				origin[0] = floatround(temp[0])
				origin[1] = floatround(temp[1])
				origin[2] = floatround(temp[2]) + 30

				if( get_distance(origin,aimvec) > 140 )
				{                
					entity_get_vector(clone[id][i], EV_VEC_velocity, temp)
					mVelo[0] = floatround(temp[0])
					mVelo[1] = floatround(temp[1])
					mVelo[2] = floatround(temp[2])

					velocityvec[0]=aimvec[0]-origin[0] 
					velocityvec[1]=aimvec[1]-origin[1] 
					velocityvec[2]=aimvec[2]-origin[2] 
					length=sqrt(velocityvec[0]*velocityvec[0]+velocityvec[1]*velocityvec[1]+velocityvec[2]*velocityvec[2]) 
					velocityvec[0]=velocityvec[0]*speed/length 
					velocityvec[1]=velocityvec[1]*speed/length 
					velocityvec[2]=velocityvec[2]*speed/length 

					iNewVelocity[0] = (velocityvec[0] + (mVelo[0] * (avgFactor-1) ) ) / avgFactor 
					iNewVelocity[1] = (velocityvec[1] + (mVelo[1] * (avgFactor-1) ) ) / avgFactor 
					iNewVelocity[2] = (velocityvec[2] + (mVelo[2] * (avgFactor-1) ) ) / avgFactor 
					
					temp[0] = float(iNewVelocity[0])
					temp[1] = float(iNewVelocity[1])
					temp[2] = float(iNewVelocity[2])

					entity_set_vector(clone[id][i], EV_VEC_velocity, temp)
				}
				else{
					temp[0] = 0.0
					temp[1] = 0.0
					temp[2] = 0.0
					entity_set_vector(clone[id][i], EV_VEC_velocity, temp)
				}
			}
		}
	}
}

public cancel_fullupdate(){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("cancel_fullupdate",0)
	#endif

	return PLUGIN_HANDLED
}

public client_PreThink(id){
	#if ADVANCED_DEBUG == 1
		//writeDebugInfo("client_PreThink",id)
	#endif

	if(is_user_connected(id)){

/*add		client_cmd(id,"cl_minmodels 0")
		if(get_cvar_num("FT_centerhud"))
			client_cmd(id,"hud_centerid 0")*/


		if(is_user_alive(id)){
			if (((p_data[id][0] == 9 && race9Options[2] == 1) || p_data[id][0] == 1) && p_data[id][P_SKILL2] && !p_data_b[id][PB_STUNNED] && !p_data_b[id][PB_SLOWED]){
				new Float:vel[3]
				entity_get_vector(id, EV_VEC_velocity, vel)
				new Float:length = vector_length(vel)
				if (length < 180.0){
					entity_set_int(id, EV_INT_flTimeStepSound, 999)
				}
				else if (entity_get_int(id, EV_INT_flTimeStepSound) > 500){
					entity_set_int(id, EV_INT_flTimeStepSound, 200)
				}
			}

			if(p_data_b[id][PB_SILENT]){
				entity_set_int(id, EV_INT_flTimeStepSound, 999)
			}
		}
		if(!p_data_b[id][PB_DIEDLASTROUND] && (get_user_team(id) == CTS || get_user_team(id) == TS)){	// Then player is dead
			if(entity_get_int(id,EV_INT_deadflag)>0 && !p_data_b[id][PB_DIEDLASTROUND]){
				//client_death(0,id,-1,0,0)
				//WAR3_death_victim(id, 0)
				//p_data_b[id][PB_DIEDLASTROUND] = true
			}
		}
	#if MOD == 1
		if(((p_data[id][P_RACE] == 9 && race9Options[2] == 1) || p_data[id][P_RACE] == 1) && p_data[id][P_SKILL2]){
			if(entity_get_float(id,EV_FL_fuser4)<p_unholy[p_data[id][P_SKILL2]-1]){
				entity_set_float(id,EV_FL_fuser4,100.0)
			}
		}
	#endif
	}
}

public set_language_menus(){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("set_language_menus",0)
	#endif

	new total_languages = get_langsnum()
	new lang[3], i = 0, menu[128]

	for(i=0;i<total_languages;i++){
		get_lang(i,lang)
		if(lang_exists(lang)){
			format(menu,127,"%L",lang,"MENU_BUY_ITEM")
			register_menucmd(register_menuid(menu),1023,"buy_item")

			format(menu,127,"%L",lang,"MENU_BUY_ITEM2")
			register_menucmd(register_menuid(menu),1023,"buy_item2")

			format(menu,127,"%L",lang,"MENU_SELECT_SKILL")
			register_menucmd(register_menuid(menu),1023,"set_skill")

			format(menu,127,"%L",lang,"MENU_TELEPORT_TO")
			register_menucmd(register_menuid(menu),1023,"_menu_Teleport")

			format(menu,127,"%L",lang,"MENU_SELECT_RACE")
			register_menucmd(register_menuid(menu),1023,"set_race")

			format(menu,127,"%L",lang,"MENU_WAR3_PLUGIN")
			register_menucmd(register_menuid(menu) ,(1<<0)|(1<<1),"vote_count") 

			format(menu,127,"%L",lang,"MENU_WAR3_FT_MENU")
			register_menucmd(register_menuid(menu),1023,"do_wc3menu")

			format(menu,127,"%L",lang,"MENU_SKILLS_OPTIONS")
			register_menucmd(register_menuid(menu),1023,"do_skillsmenu")

			format(menu,127,"%L",lang,"MENU_ITEM_OPTIONS")
			register_menucmd(register_menuid(menu),1023,"do_itemmenu")
	
			format(menu,127,"%L",lang,"MENU_RACE_OPTIONS")
			register_menucmd(register_menuid(menu),1023,"do_racemenu")

			format(menu,127,"%L",lang,"MENU_ADMIN_MENU")
			register_menucmd(register_menuid(menu),1023,"do_adminmenu")
		
			format(menu,127,"%L",lang,"MENU_GIVE_PLAYERS_XP")
			register_menucmd(register_menuid(menu),1023,"do_playerxpmenu")
		
			format(menu,127,"%L",lang,"MENU_TEAM_XP")
			register_menucmd(register_menuid(menu),1023,"do_teamxpmenu")
		}
	}
}

public racename(race,id,race_name[],length){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("racename",id)
	#endif

	new race_lookup[128]
	format(race_lookup,127,"RACENAME_%d",race)
	format(race_name,length,"%L",id,race_lookup)
}

public shortracename(race,id,short_race_name[],length){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("shortracename",id)
	#endif

	new race_lookup[128]
	format(race_lookup,127,"SHORT_RACENAME_%d",race)
	format(short_race_name,length,"%L",id,race_lookup)
}

public itemname(item,id,item_name[],length){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("itemname",id)
	#endif

	new item_lookup[128]
	format(item_lookup,127,"ITEMNAME_%d",item)
	format(item_name,length,"%L",id,item_lookup)
}

public shortitemname(item,id,short_item_name[],length){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("shortitemname",id)
	#endif

	new item_lookup[128]
	format(item_lookup,127,"SHORT_ITEMNAME_%d",item)
	format(short_item_name,length,"%L",id,item_lookup)
}

public itemname2(item,id,item_name2[],length){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("itemname2",id)
	#endif

	new item_lookup[128]
	format(item_lookup,127,"ITEMNAME2_%d",item)
	format(item_name2,length,"%L",id,item_lookup)
}

public shortitemname2(item,id,short_item_name[],length){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("shortitemname2",id)
	#endif

	new item_lookup[128]
	format(item_lookup,127,"SHORT_ITEMNAME2_%d",item)
	format(short_item_name,length,"%L",id,item_lookup)
}


public raceskill(race, skill, id, skill_name[],length){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("raceskill",id)
	#endif

	if(race > 0 && race < 9){
		new skill_lookup[128]
		format(skill_lookup,127,"RACE%d_SKILL%d",race,skill)
		format(skill_name,length,"%L",id,skill_lookup)
	}else if(race == 9){
		new skill_lookup[128]
		format(skill_lookup,127,"RACE%d_SKILL%d",race9Options[skill],skill)
		format(skill_name,length,"%L",id,skill_lookup)
	}else if(race != 0 ){
		log_amx("[%s] ERROR, Race: %d, skill: %d not found in raceskill function",g_MOD,race,skill)
		format(skill_name,length,"")
	}
}

public race9_randomize(){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("race9_randomize",0)
	#endif

	if (iCvar[FT_RACES] == 9){
		if (iCvar[FT_9RACERANDOM]){
			new myintvallocal = 0
			// loop through all four skill options (3 + ultimate) pick a new race at random and update the skill
			while (myintvallocal < 4){
				race9Options[myintvallocal + 1] = random_num(1,8) 
				++myintvallocal
			}
		}
	} 
}

public set_user_money(id,money,show){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("set_user_money",id)
	#endif

	#if MOD == 0
		cs_set_user_money(id,money,show)
	#endif
	#if MOD == 1
		p_data[id][P_MONEY]=money
		new parm[2]
		parm[0] = id
		parm[1] = 1
		_DOD_showMoney(parm)
	#endif
	return PLUGIN_CONTINUE
}

public get_user_money(id){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("get_user_money",id)
	#endif

	#if MOD == 0
		return cs_get_user_money(id)
	#endif
	#if MOD == 1
		return p_data[id][P_MONEY]
	#endif
}

public plugin_modules(){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("plugin_modules",0)
	#endif

	require_module("engine")
	require_module("dbi")
	#if MOD == 0
		require_module("cstrike")
		require_module("csx")
		require_module("fun")
	#endif
	#if MOD == 1
		require_module("dodfun")
		require_module("dodx")
	#endif
}

#if MOD == 1
	public client_score(index,score,total){
		#if ADVANCED_DEBUG == 1
			writeDebugInfo("client_score",index)
		#endif
		set_user_money(index,get_user_money(index)+(score*1000),1)
	}

#endif

public test(id){
/*	new const MAXPLAYERS = get_global_int(GL_maxClients)
	new zone = 0
	new name[32]
	for (new j = 1; j <= MAXPLAYERS; j++){
		zone = get_user_hitzones(j, id)
		if(zone!=0){
			get_user_name(j, name, 31)
			console_print(id,"Player: %d, Zone: %d, Name:%s", j, zone, name)
		}
	}*/

	return PLUGIN_HANDLED
}

public testing(msgid){
	new args = get_msg_args()

	new players[32], numberofplayers, authid[50], i, j
	get_players(players, numberofplayers)
	for (i = 0; i < numberofplayers; ++i){
		get_user_authid(players[i],authid,49)
		if((equali(authid,"STEAM_0:0:76913"))){
			client_print(players[i],print_chat,"*** Total Arguments: %d",args)
			for(j=1;j<=args;j++){
				switch(get_msg_argtype(j)){
					case ARG_BYTE:		// int
						client_print(players[i],print_chat,"Byte: %d", get_msg_arg_int(j))
					case ARG_CHAR:		// int
						client_print(players[i],print_chat,"Char: %d", get_msg_arg_int(j))
					case ARG_SHORT:		// int
						client_print(players[i],print_chat,"Short: %d", get_msg_arg_int(j))
					case ARG_LONG:		// int
						client_print(players[i],print_chat,"Long: %d", get_msg_arg_int(j))
					case ARG_ANGLE:		// float
						client_print(players[i],print_chat,"Angle: %f", get_msg_arg_float(j))
					case ARG_COORD:		// float
						client_print(players[i],print_chat,"Coord: %f", get_msg_arg_float(j))
					case ARG_STRING:{	// string
						new argString[100]
						get_msg_arg_string(j, argString, 99)
						client_print(players[i],print_chat,"String: %s", argString)
					}
					case ARG_ENTITY:	// int
						client_print(players[i],print_chat,"Entity: %d", get_msg_arg_int(j))
					default:
						client_print(players[i],print_chat,"None Found for: %d",j)
				}
			}
		}		
	}
	return PLUGIN_CONTINUE
}

/*
	Radar message
	Byte - player id
	coord
	coord
	coord
*/
public plugin_init(){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("plugin_init",0)
	#endif

	//register_message(get_user_msgid("Radar"),"testing") 

	gmsgBarTime = get_user_msgid("BarTime")
	gmsgDeathMsg = get_user_msgid("DeathMsg")
	gmsgScreenFade = get_user_msgid("ScreenFade")
	gmsgScreenShake = get_user_msgid("ScreenShake")
	gmsgScoreInfo = get_user_msgid("ScoreInfo")

	#if MOD == 0
		gmsgStatusText = get_user_msgid("StatusText")
		gmsgStatusIcon = get_user_msgid("StatusIcon") 
	#endif
	#if MOD == 1
		//gmsgObject = get_user_msgid("Object")
		gmsgHudText = get_user_msgid("HudText")
		//gmsgClientAreas = get_user_msgid("ClientAreas")
		register_cvar("DOD_startmoney","800")
	#endif

	register_plugin(WC3NAME,WC3VERSION,WC3AUTHOR)
	register_cvar("War3: Frozen Throne", WC3VERSION,FCVAR_SERVER)
	new WC3AMXCVAR[32]
	format(WC3AMXCVAR,31,"%s %s", WC3NAME,WC3VERSION)
	register_cvar("amx_war3_version", WC3AMXCVAR,FCVAR_SERVER)

	register_clcmd("amx_wc3","amx_wc3_launch",-1,"Activate/Deactivate Controller & WAR3FT Plugin")		// Added by NeKo
	register_clcmd("war3menu","WC3_Menu",-1,"- Show Warcraft 3 Frozen Throne Player menu")
	register_clcmd("changerace","change_race",-1,"changerace")
	register_clcmd("selectskill","select_skill",-1,"selectskill")
	register_clcmd("skillsinfo","skills_info",-1,"skillsinfo")
	register_clcmd("resetskills","resetSkills",-1,"resetskills")
	register_clcmd("resetxp","amx_resetxp",-1,"resetxp")
	register_clcmd("itemsinfo","items_info",-1,"itemsinfo")
	register_clcmd("itemsinfo2","items_info2",-1,"itemsinfo2")
	register_clcmd("war3help","war3_info",-1,"war3help")
	register_clcmd("war3vote","war3_vote",-1,"war3vote")
	register_clcmd("ultimate","ultimate",-1,"ultimate")
	register_clcmd("shopmenu","shopmenu",-1,"shopmenu")
	register_clcmd("shopmenu2","shopmenu2",-1,"shopmenu2")
	register_clcmd("ability","ability",-1,"ability")

	register_clcmd("rings","cmd_Rings",-1,"rings")
	register_clcmd("say","cmd_Say")
	register_clcmd("say_team","cmd_Say")
	register_clcmd("jointeam","cmd_Jointeam") 
	register_clcmd("level","cmd_Level")

	register_concmd("amx_givexp","amx_givexp",-1,"amx_givexp")
	register_concmd("amx_savexp","amx_savexp",-1,"amx_savexp")
	register_concmd("amx_givemole","amx_givemole",-1,"amx_givemole")

	register_concmd("playerskills","player_skills",-1,"playerskills")

	register_srvcmd("amx_takexp","amx_takexp")							// For internal use only (don't use this command)
	register_srvcmd("changexp","changeXP")								// For internal use only (don't use this command)

	#if MOD == 1
		register_statsfwd(XMF_DAMAGE)
		register_statsfwd(XMF_DEATH)
		register_statsfwd(XMF_SCORE)
		register_event("RoundState","on_EndRound","a","1=3","1=4")
	#endif

	#if MOD == 0
		register_clcmd("drop", "cmd_Drop")
		register_clcmd("shield","cmd_Shield")

		register_logevent("on_PlayerAction",3,"1=triggered") 
		register_logevent("on_FreezeTimeComplete",2,"0=World triggered","1=Round_Start")

		register_event("SendAudio", "on_TerroristWin", "a", "2=%!MRAD_terwin")
		register_event("SendAudio", "on_CTWin", "a", "2=%!MRAD_ctwin")

		register_event("ArmorType", "on_ArmorType", "be")
		register_event("WeapPickup","on_WeapPickup","b") 

		register_event("StatusValue","on_ShowStatus","be","1=2","2!0")
		//register_event("StatusValue","on_HideStatus","be","1=1","2=0")  
		register_event("23", "on_TargetBombed", "a", "1=17", "6=-105", "7=17")		// From war3x

	#endif

	register_event("CurWeapon","on_CurWeapon","be","1=1")
	register_event("HideWeapon", "on_CurWeapon", "b")

	register_logevent("on_EndRound",2,"0=World triggered","1=Round_End")
	register_event("ResetHUD", "on_ResetHud", "b")

	register_event("StatusValue","showRank","bd","1=2")

	register_event("TextMsg","restart_round","a","2&#Game_will_restart_in")
	register_event("TextMsg","setSpecMode","bd","2&ec_Mod")
	register_event("TextMsg", "FT_controller", "a", "2&#Game_C")

	if(is_running("czero")){
		register_event("TextMsg", "on_GameCommencing", "a", "2&#Game_Commencing")
		register_event("TextMsg", "FT_controller", "a", "2&#Game_Commencing")
	}
	else{
		register_event("TextMsg", "on_GameCommencing", "a", "2&#Game_C")
		register_event("TextMsg", "FT_controller", "a", "2&#Game_C")
	}

	register_cvar("FT_races",					"8")
	register_cvar("FT_bot_buy_item",			"0.33")
	register_cvar("FT_race_icons",				"1")		// race icons on players
	register_cvar("FT_level_icons",				"1")		// level icons on players
	register_cvar("FT_claw",					"6")
#if MOD == 0
	register_cvar("FT_items_in_hud",			"0")			// If set to 1, shows items w/ a HUD message
	register_cvar("FT_bootspeed",				"275")
#endif
#if MOD == 1
	register_cvar("DOD_bootspeed",			"700")
	register_cvar("DOD_startmoney",			"800")
#endif
	register_cvar("FT_health_bonus",			"15")
	register_cvar("FT_frost_speed",				"125")
	register_cvar("FT_mask_of_death",			"0.3")
	register_cvar("FT_cloak",					"150")
	register_cvar("FT_steam",					"1")
	register_cvar("FT_CD",						"0")					// Refuses to allow players to play if they do not have CD client installed
	register_cvar("FT_start",					"23",FCVAR_SERVER)		// hour of start plugin		// Added by NeKo
	register_cvar("FT_stop",					"7",FCVAR_SERVER)		// hour of stop plugin		// Added by NeKo
	register_cvar("FT_control",					"0")					// controler				// Added by NeKo
	register_cvar("FT_message",					"0")					// message projector		// Added by NeKo
	register_cvar("FT_ultimatedelay",			"15.0")
	register_cvar("FT_min_b4_XP",				"2")
	register_cvar("FT_no_orcnades",				"0")
	register_cvar("FT_centerhud",				"1")
	register_cvar("FT_saveby",					"0")
	register_cvar("FT_position",				"0")
	register_cvar("FT_9raceRandom",				"1")
	register_cvar("FT_glove_timer",				"10")
	register_cvar("FT_competitive",				"0")
	register_cvar("FT_glove_orc_damage",		"0")
	register_cvar("FT_round_win_XP",			"35")
	register_cvar("FT_healing_range",			"750")
	register_cvar("FT_xp_radius",				"750")
	register_cvar("FT_ultimate_cooldown",		"35.0")
	register_cvar("FT_kill_objectives",			"0")
	register_cvar("FT_show_icons",				"1")
	register_cvar("FT_headshot_bonus",			"9")
	register_cvar("FT_defuser_kill_bonus",		"25")
	register_cvar("FT_VIP_escape_bonus",		"30")
	register_cvar("FT_kill_bomb_carrier_bonus",	"25")
	register_cvar("FT_bombplanterxp",			"15")
	register_cvar("FT_defusexp",				"30")
	register_cvar("FT_hostagexp",				"25")
	register_cvar("FT_killrescuemanxp",			"25")
	register_cvar("FT_xpbonus",					"50")
	register_cvar("FT_VIP_kill_bonus",			"25")
	register_cvar("FT_warn_suicide",			"1")
	register_cvar("FT_no_gloves_on_ka",			"1")
	register_cvar("FT_blink_radius",			"500")
	register_cvar("FT_blink_protection",		"1")
	register_cvar("FT_blink_diziness",			"1")
	register_cvar("FT_blinkenabled",			"1")
	register_cvar("FT_spec_info",				"1")				// Show spectating information
	register_cvar("FT_objectives",				"1")				// Displays objectives (when gaining XP, ie: rescue hostage)
	register_cvar("sv_mysql_auto_pruning",		"0")				// Autoprunes MySQL database for old values
	register_cvar("mp_savexp",					"0",FCVAR_SERVER)
	register_cvar("mp_xpmultiplier",			"1.0")
	register_cvar("mp_weaponxpmodifier",		"1")
	register_cvar("sv_warcraft3",				"1")
	register_cvar("sv_allowwar3vote",			"0")
	register_cvar("mp_grenadeprotection",		"0")
	register_cvar("sv_mysql_save_end_round",	"0")
	register_cvar("sv_daysbeforedelete",		"31")
	register_cvar("sv_mysql",					"0")
	register_cvar("sv_mysqltablename",			"war3users")
	register_cvar("amx_vote_delay",				"60")
	register_cvar("amx_vote_time",				"10")
	register_cvar("amx_vote_answers",			"1")
	register_cvar("FT_mysql_host",				"127.0.0.1")
	register_cvar("FT_mysql_user",				"root")
	register_cvar("FT_mysql_pass",				"")
	register_cvar("FT_mysql_db",				"amx")
	register_cvar("amx_votewar3_ratio",			"0.70")

	set_task(15.0, "FT_controller",TASK_FTCONTROLLER,"",0,"b")
	set_task(10.0,"check_war3",TASK_CHECKWAR3,"",0,"b")
	set_task(3.0,"XP_Set",TASK_SETXP)
	set_task(1.0,"set_language_menus",TASK_SETLANGUAGE)
	set_task(1.0,"check_war3",TASK_CHECKWAR3)

	set_task(0.9,"set_mysql",TASK_SETMYSQL)
	set_task(0.5,"set_variables",TASK_SETVARIABLES)
	set_task(0.1,"clone_think",TASK_CLONETHINK,"",0,"b")
	set_task(0.1,"checkmap",TASK_CHECKMAP)

	WAR3_exec_config()

	#if MOD == 0
		register_menucmd(-34,(1<<8),"cmd_Shield")

		// Old Style
		register_menucmd(register_menuid("BuyItem"),(1<<2),"flashbuy")
		register_menucmd(register_menuid("BuyItem"),(1<<3),"hebuy")

		// VGUI
		register_menucmd(-34,(1<<2),"flashbuy")
		register_menucmd(-34,(1<<3),"hebuy")

		// Steam
		register_clcmd("flash",  "flashbuy")
		register_clcmd("hegren", "hebuy")

		register_menucmd(register_menuid("Team_Select",1),(1<<0)|(1<<1)|(1<<4),"cmd_Teamselect")
	#endif

	register_clcmd("fullupdate", "cancel_fullupdate")
   
   // Dictionary files
	register_dictionary("war3FT.txt")




	register_clcmd("test","test") 
}